package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.JsoupUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.XmlUtils;
import com.diaoyun.zion.master.util.SpiderUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Fendi(芬迪) 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("fendiSpider")
public class FendiSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Fendi(芬迪) 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.FENDI.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     *
     * TODO 存在一个是否为 JSONObject 或 JSONArray 的判断
     *
     * @param content 主要的网页内容
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content) throws IOException, URISyntaxException {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 转换为 Document 对象
        Document document = Jsoup.parse(content);

        // 通过获取商品的 id 访问商品所有款式的接口
        String pId = JsoupUtil.getScriptTagVariableContent(content, "window.productId");
        String pUrl = "https://www.fendi.cn/api/rest/color?product_id=" + pId;
        String pContent = HttpClientUtil.getContentByUrl(pUrl, PlatformEnum.FENDI.getValue());
        pContent = XmlUtils.convertXmlIntoJSONObject(pContent);
        JSONObject pUrlObj = JSONObject.fromObject(pContent);
        //////////////////////////////////// 获取商品基本信息 //////////////////////////////////////////////////
        itemInfo.setShopName("Fendi");
        itemInfo.setShopUrl("https://www.fendi.cn/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(document.select("div[class=info__summary]").text().trim());
        //////////////////////////////////// 获取商品基本信息End ///////////////////////////////////////////////


        JSONArray dataArr = pUrlObj.getJSONObject("magento_api").getJSONObject("data").getJSONArray("data_item");
        for (int i = 0; i < dataArr.size(); i++) {
            JSONObject dataObj = dataArr.getJSONObject(i);
            //////////////////////////////////// 获取商品颜色属性 //////////////////////////////////////////////////

            // 获取每个款式的页面信息
            pUrl = dataObj.getString("url");
            content = HttpClientUtil.getContentByUrl(pUrl, PlatformEnum.FENDI.getValue());

            String colorNo = dataObj.getString("id");
            String imgUrl = dataObj.getString("image");
            document = Jsoup.parse(content);

            if (i == 0) {
                itemInfo.setPic(imgUrl);
            }

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(document.select("div[class=info__summary]").text().trim());
            productPropColor.setImage("http://" + imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            String fullPrice = JsoupUtil.getScriptTagVariableContent(content, "window.final_price_value");
            fullPrice = SpiderUtil.exchangeRate(fullPrice);

            JSONObject skuObj = JsoupUtil.getItemDetailByName(content, "window.spStockItems");
            JSONObject sizeObj = JsoupUtil.getItemDetailByName(content, "window.spConfig");
            JSONObject attributesObj = sizeObj.getJSONObject("attributes");
            // 往下迭代一层
            Iterator iterator = attributesObj.keys();
            JSONArray optionsArr = new JSONArray();
            while(iterator.hasNext()){
                String key = (String) iterator.next();
                String value = attributesObj.getString(key);
                optionsArr = JSONObject.fromObject(value).getJSONArray("options");
            }
            for (int j = 0; j < optionsArr.size(); j++) {
                JSONObject optionsObj = optionsArr.getJSONObject(j);

                ///////////////////////// 获取商品尺码属性 ////////////////////
                ProductProp productPropSize = new ProductProp();
                String sizeNo = optionsObj.getJSONArray("products").toString();

                sizeNo = SpiderUtil.retainNumber(sizeNo);

                String size = optionsObj.getString("label");

                productPropSize.setPropName(size);
                productPropSize.setPropId(sizeNo);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 商品的库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                ProductSkuStock productSkuStock = new ProductSkuStock();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                // 获取库存数
                int sellableQuantity = Integer.valueOf(skuObj.getJSONObject(sizeNo).getString("qty"));

                productSkuStock.setSellableQuantity(sellableQuantity);
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END///////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Fendi");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}