package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.SpiderUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * Burberry(博柏利) 数据爬虫
 * TODO 需要模拟登录，暂留
 * @author 爱酱油不爱醋
 */
public class BurberrySpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Burberry(博柏利) 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String[] spilt = targetUrl.split("/");
        spilt = spilt[5].split("[?]");
        String pId = spilt[0];
        String styleId = pId.substring(0, 5);
        targetUrl = "https://www.gucci.cn/zh/pr/sameStyleBuriedPoint?itemCode=" + pId +"&style=" + styleId + "&categoryPath=&_=1572859976423";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.GUCCI.getValue());
        ProductResponse productResponse = formatProductResponse(content, pId);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        JSONObject dataMap = JSONObject.fromObject(content);

        // 取 data 节点对象
        JSONObject dataObj = dataMap.getJSONObject("data");
        // 如果获取的长度为空，哪说明没有在商品的详情页内，返回空参数
        if (dataObj.size() == 0) {
            return productResponse;
        }

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName(PlatformEnum.COACH.getLabel());
        itemInfo.setShopUrl("https://china.coach.com");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(dataObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息(图片下取)End /////////////////////////

        List<String> sizeNoList = new ArrayList<>();
        List<String> colorNoList = new ArrayList<>();
        // 取 attributes 节点数组
        JSONArray attributesArr = dataObj.getJSONArray("attributes");

        for (int i = 0; i < attributesArr.size(); i++) {
            ///////////////////////// 获取商品颜色属性 ////////////////////////////////////////////////////////////////
            // 0 位为颜色属性
            if (i == 0) {
                // 取 values 节点数组
                JSONArray valuesArr = attributesArr.getJSONObject(i).getJSONArray("values");

                for (int j = 0; j < valuesArr.size(); j++) {
                    JSONObject valuesObj = valuesArr.getJSONObject(j);
                    // 获取图片路径
                    String imageUrl = valuesObj.getString("image");
                    // 设置商品基本信息的图片
                    if (i == 0) {
                        itemInfo.setPic(imageUrl);
                    }
                    ProductProp productPropColor = new ProductProp();
                    String colorNo = valuesObj.getString("value_index");
                    colorNoList.add(colorNo);
                    productPropColor.setPropId(colorNo);
                    productPropColor.setPropName(valuesObj.getString("label"));
                    productPropColor.setImage(imageUrl);
                    propSet.add(productPropColor);
                    if (productPropSet.get("颜色") == null) {
                        productPropSet.put("颜色", propSet);
                    } else {
                        Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                        propSet.addAll(oldPropSet);
                        productPropSet.put("颜色", propSet);
                    }
                }
                ///////////////////////// 获取商品颜色属性End ////////////////////////////////////////////////////////////////


                // 1 位为尺寸属性(有的商品不一定会存在，如手提包)
            } else if (i == 1) {
                // 取 values 节点数组
                JSONArray valuesArr = attributesArr.getJSONObject(i).getJSONArray("values");

                ///////////////////////// 获取商品尺码属性 ////////////////////////////////////////////////////////////////
                for (int j = 0; j < valuesArr.size(); j++) {
                    JSONObject valuesObj = valuesArr.getJSONObject(j);
                    ProductProp productPropSize = new ProductProp();

                    String sizeNo = valuesObj.getString("value_index");

                    sizeNoList.add(sizeNo);
                    productPropSize.setPropId(sizeNo);
                    productPropSize.setPropName(valuesObj.getString("label"));
                    sizePropSet.add(productPropSize);
                    if (productPropSet.get("尺码") == null) {
                        productPropSet.put("尺码", sizePropSet);
                    } else {
                        Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                        sizePropSet.addAll(oldPropSet);
                        productPropSet.put("尺码", sizePropSet);
                    }
                    ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////
                }
            }

        }

        for (String colorNo : colorNoList) {
            for (String sizeNo : sizeNoList) {
                // 设置 skuStr
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";
                // 设置：商品包含库存信息
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                // 获取商品的原始价(存在优惠价格)
                OriginalPrice originalPrice = new OriginalPrice();
                String fullPrice = dataObj.getString("price");
                fullPrice = SpiderUtil.retainNumber(fullPrice);
                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = exchangeRate(fullPrice);
                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                originalPrice.setPrice(fullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END //////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.COACH.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
