package com.diaoyun.zion.master.util;

import com.diaoyun.zion.chinafrica.service.TbCfFeeService;

import java.math.BigDecimal;
import java.util.regex.Pattern;

/**
 * 用于爬虫的数据处理的工具类
 *
 * @author 爱酱油不爱醋
 */
public class SpiderUtil {

    private static BigDecimal rate;

    static {
        TbCfFeeService tbCfFeeService = (TbCfFeeService) SpringContextUtil.getBean("tbCfFeeService");
        rate = tbCfFeeService.getRateFee().getFeeRate();
    }

    /**
     * 转换汇率--由人民币转换为美元
     * TODO 同步汇率问题
     * 注意：暂时从后台获取人工设置的汇率，还未是动态获取
     * @param fullPrice 原始价格
     * @return 汇率计算的价格
     */
    public static String exchangeRate(String fullPrice) {
        return new BigDecimal(fullPrice).divide(rate, 2, BigDecimal.ROUND_UP).toString();
    }

    /**
     * 去除除了数字之外的所有字符
     *
     * @param str 字符串
     * @return 只有数字的字符串
     */
    public static String retainNumber(String str) {
        str = Pattern.compile("[^0-9]").matcher(str).replaceAll("").trim();
        return str;
    }

}

