package com.diaoyun.zion.master.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
/**
 * 短信接口类
 * @author lyl
 *
 * 2018年4月18日
 */
public class SMSUtil {

	//查账户信息的http地址
	private static String URI_GET_USER_INFO = "https://sms.yunpian.com/v2/user/get.json";

	//模板发送接口的http地址
    private static String URI_TPL_SEND_SMS = "https://sms.yunpian.com/v2/sms/tpl_single_send.json";
	//private static String URI_TPL_SEND_SMS ="https://sms.yunpian.com/v2/sms/single_send.json";
	//编码格式。发送编码格式统一用UTF-8
    private static String ENCODING = "UTF-8";
	private String API_KEY="cb20310db0e7dcc76a827afbd2ba548f";
    
    /**
	  * 查询用户信息
	  * 
	  * @param apikey
	  * @return
	  * @throws IOException
	  * @throws URISyntaxException
	  */
	public static String getUserInfo(String apikey) throws IOException, URISyntaxException {
       Map<String, String> params = new HashMap<String, String>();
       params.put("apikey", apikey);
       return post(URI_GET_USER_INFO, params);
   }
	
	/**
	 * 提交响应
	 * 
	 * @param url
	 * @param paramsMap
	 * @return
	 */
	 public static String post(String url, Map<String, String> paramsMap) {
	        CloseableHttpClient client = HttpClients.createDefault();
	        String responseText = "";
	        CloseableHttpResponse response = null;
	            try {
	                HttpPost method = new HttpPost(url);
	                if (paramsMap != null) {
	                    List<NameValuePair> paramList = new ArrayList<NameValuePair>();
	                    for (Map.Entry<String, String> param : paramsMap.entrySet()) {
	                        NameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
	                        paramList.add(pair);
	                    }
	                    method.setEntity(new UrlEncodedFormEntity(paramList, ENCODING));
	                }
	                response = client.execute(method);
	                HttpEntity entity = response.getEntity();
	                if (entity != null) {
	                    responseText = EntityUtils.toString(entity, ENCODING);
	                }
	            } catch (Exception e) {
	                e.printStackTrace();
	            } finally {
	                try {
	                    response.close();
	                } catch (Exception e) {
	                    e.printStackTrace();
	                }
	            }
	            return responseText;
	        }
	
	
	/**
	 * 发送验证码
	 * 
	 * @return
	 * @throws IOException 
	 */
	public String yzCode(String phone) throws IOException{

		if(phone.equals(null)){
			return "error";
		}
	    //编码格式。发送编码格式统一用UTF-8
	    String ENCODING = "UTF-8";
	    long tpl_id = 3253208;//模板ID
	    String code = RandomStringUtils.randomNumeric(6);// 生成6位随机验证码
		String tpl_value = URLEncoder.encode("#code#",ENCODING) +"="
				+ URLEncoder.encode(code, ENCODING) ;
	    System.out.println(tpl_value);
        System.out.println(SMSUtil.tplSendSms(API_KEY, tpl_id, tpl_value, phone));
		return code;
	}
	
	/**
	 * 通过模板发送短信
	 * 
	 * @param apikey
	 * @param tpl_id
	 * @param tpl_value
	 * @param mobile
	 * @return
	 * @throws IOException
	 */
	public static String tplSendSms(String apikey, long tpl_id, String tpl_value, String mobile) throws IOException {
        Map<String, String> params = new HashMap<String, String>();
        params.put("apikey", apikey);
        params.put("tpl_id", String.valueOf(tpl_id));
        params.put("tpl_value", tpl_value);
        params.put("mobile", mobile);
        return post(URI_TPL_SEND_SMS, params);
    }
	public static String singleSend(String apikey, String text, String mobile) {
		Map<String, String> params = new HashMap<String, String>();//请求参数集合
		params.put("apikey", apikey);
		params.put("text", text);
		params.put("mobile", mobile);
		return post("https://sms.yunpian.com/v2/sms/single_send.json", params);//请自行使用post方式请求,可使用Apache HttpClient
	}
	public static void main(String[] args) throws IOException {
	   // SMSUtil.singleSend(URI_TPL_SEND_SMS,"code","+8613751400455");
		SMSUtil s=new SMSUtil();
		String s1 = s.yzCode("+260972134374");

	}
}

