package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.service.ShopifyService;
import com.diaoyun.zion.chinafrica.vo.ShopifyConstant;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.github.pagehelper.PageInfo;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;


import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * @Auther: wudepeng
 * @Date: 2019/11/15
 * @Description:
 */
@Service("shopifyService")
public class ShopifyServiceImpl implements ShopifyService {
    private static Logger logger = LoggerFactory.getLogger(ShopifyServiceImpl.class);

    /**
     * 查询商品
     *
     * @return
     */
    @Override
    public Result queryShopifyProducts() {
        Result result = new Result();
        Map<String, Object> params = new HashMap<>();
        List<String> list = new ArrayList();
        try {
            List type = getProductType();
            for (int i = 0; i < type.size(); i++) {
                params.put("product_type", type.get(i));
                params.put("limit", ShopifyConstant.SHOPIFY_LIMIT);
                String data = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
                list.add(data);
            }
            JSONArray jsonArr = JSONArray.fromObject(list);
            result.setData(jsonArr).setMessage("success");
        } catch (IOException e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage(), e);
            return result;
        }
        return result;
    }

    /**
     * 查询分类商品
     *
     * @param product_type
     * @return
     */
    @Override
    public Result queryProductsByType(String product_type, String product_id) {
        Result result = new Result();
        Map<String, Object> params = new HashMap<>();
        params.put("product_type", product_type);
        params.put("limit", ShopifyConstant.SHOPIFY_PAGE_SIZE);
        params.put("since_id", product_id);
        try {
            String data = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
            JSONObject jsonObject = JSONObject.fromObject(data);
            System.out.println(jsonObject);
            result.setData(jsonObject);
        } catch (IOException e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage(), e);
            return result;
        }
        return result;
    }

    /**
     * 查询所有商品分类
     *
     * @return
     * @throws IOException
     */
    public List getProductType() throws IOException {
        Map<String, Object> params = new HashMap<>();
        params.put("fields", "product_type");
        String connection = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        List list = new ArrayList();
        JSONArray products = JSONObject.fromObject(connection).getJSONArray("products");
        for (int i = 0; i < products.size(); i++) {
            String string = products.getString(i);
            JSONObject jsonObject = JSONObject.fromObject(string);
            String product_type = jsonObject.getString("product_type");
            if (!"".equals(product_type) && !list.contains(product_type)) {
                list.add(product_type);
            }
        }
        return list;
    }
}
