package com.diaoyun.zion.chinafrica.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 实体
 * 表名 tb_cf_order
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public class TbCfOrderEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 订单id
     */
    private String orderId;
    /**
     * 订单号
     */
    private Long orderNo;
    /**
     * 订单名
     */
    private String orderName;
    /**
     * 订单创建时间
     */
    private Date orderTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 成交时间
     */
    private Date dealTime;
    /**
     * 交易关闭时间
     */
    private Date closeTime;
    /**
     * 订单状态(0取消，10未付款，20已付款，40已发货，50交易成功，60交易关闭)
     */
    private Integer orderStatus;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 收货地址Id
     */
    private String deliveryAddressId;
    /**
     * 收货地址
     */
    private String deliveryAddress;
    /**
     * 收货人
     */
    private String deliveryName;
    /**
     * 收货人手机
     */
    private String deliveryPhone;
    /**
     * 商品总价
     */
    private BigDecimal itemsPrice;
    /**
     * 总价
     */
    private BigDecimal totalPrice;
    /**
     * 实际付款
     */
    private BigDecimal realityPay;
    /**
     * 发货标志
     */
    private Integer deliveryFlag;
    /**
     * 发货时间
     */
    private Date deliveryTime;
    /**
     * 快递费
     */
    private BigDecimal expressCost;
    /**
     * 优惠券id
     */
    private String couponId;
    /**
     * 优惠券标题
     */
    private String couponTitle;
    /**
     * 优惠券减免价格
     */
    private BigDecimal couponPrice;
    /**
     * 手续费
     */
    private BigDecimal fee;
    /**
     * 税务费
     */
    private BigDecimal tax;
    /**
     * 交易号
     */
    private String payId;
    /**
     * 支付状态，0未支付，1已支付
     */
    private Integer payStatus;
    /**
     * 删除状态，0删除，1删除
     */
    private Integer enableFlag;


    /**
     * 商品品名
     */
    private String descripitionName;

    public String getDescripitionName() {
        return descripitionName;
    }

    public void setDescripitionName(String descripitionName) {
        this.descripitionName = descripitionName;
    }
    /**
     * 设置：订单id
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取：订单id
     */
    public String getOrderId() {
        return orderId;
    }
    /**
     * 设置：订单号
     */
    public void setOrderNo(Long orderNo) {
        this.orderNo = orderNo;
    }

    /**
     * 获取：订单号
     */
    public Long getOrderNo() {
        return orderNo;
    }
    /**
     * 设置：订单名
     */
    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    /**
     * 获取：订单名
     */
    public String getOrderName() {
        return orderName;
    }
    /**
     * 设置：订单创建时间
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * 获取：订单创建时间
     */
    public Date getOrderTime() {
        return orderTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
    /**
     * 设置：成交时间
     */
    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    /**
     * 获取：成交时间
     */
    public Date getDealTime() {
        return dealTime;
    }
    /**
     * 设置：交易关闭时间
     */
    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    /**
     * 获取：交易关闭时间
     */
    public Date getCloseTime() {
        return closeTime;
    }
    /**
     * 设置：订单状态(0取消，10未付款，20已付款，40已发货，50交易成功，60交易关闭)
     */
    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * 获取：订单状态(0取消，10未付款，20已付款，40已发货，50交易成功，60交易关闭)
     */
    public Integer getOrderStatus() {
        return orderStatus;
    }
    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }
    /**
     * 设置：用户名
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取：用户名
     */
    public String getUserName() {
        return userName;
    }


    /**
     * 设置：收货地址Id
     */
    public void setDeliveryAddressId(String deliveryAddressId) {
        this.deliveryAddressId = deliveryAddressId;
    }

    /**
     * 获取：收货地址Id
     */
    public String getDeliveryAddressId() {
        return deliveryAddressId;
    }
    /**
     * 设置：收货地址
     */
    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    /**
     * 获取：收货地址
     */
    public String getDeliveryAddress() {
        return deliveryAddress;
    }
    /**
     * 设置：收货人
     */
    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    /**
     * 获取：收货人
     */
    public String getDeliveryName() {
        return deliveryName;
    }
    /**
     * 设置：收货人手机
     */
    public void setDeliveryPhone(String deliveryPhone) {
        this.deliveryPhone = deliveryPhone;
    }

    /**
     * 获取：收货人手机
     */
    public String getDeliveryPhone() {
        return deliveryPhone;
    }
    /**
     * 设置：商品总价
     */
    public void setItemsPrice(BigDecimal itemsPrice) {
        this.itemsPrice = itemsPrice;
    }

    /**
     * 获取：商品总价
     */
    public BigDecimal getItemsPrice() {
        return itemsPrice;
    }
    /**
     * 设置：总价
     */
    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    /**
     * 获取：总价
     */
    public BigDecimal getTotalPrice() {
        return totalPrice;
    }
    /**
     * 设置：实际付款
     */
    public void setRealityPay(BigDecimal realityPay) {
        this.realityPay = realityPay;
    }

    /**
     * 获取：实际付款
     */
    public BigDecimal getRealityPay() {
        return realityPay;
    }
    /**
     * 设置：发货标志
     */
    public void setDeliveryFlag(Integer deliveryFlag) {
        this.deliveryFlag = deliveryFlag;
    }

    /**
     * 获取：发货标志
     */
    public Integer getDeliveryFlag() {
        return deliveryFlag;
    }
    /**
     * 设置：发货时间
     */
    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    /**
     * 获取：发货时间
     */
    public Date getDeliveryTime() {
        return deliveryTime;
    }
    /**
     * 设置：快递费
     */
    public void setExpressCost(BigDecimal expressCost) {
        this.expressCost = expressCost;
    }

    /**
     * 获取：快递费
     */
    public BigDecimal getExpressCost() {
        return expressCost;
    }
    /**
     * 设置：优惠券id
     */
    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    /**
     * 获取：优惠券id
     */
    public String getCouponId() {
        return couponId;
    }
    /**
     * 设置：优惠券标题
     */
    public void setCouponTitle(String couponTitle) {
        this.couponTitle = couponTitle;
    }

    /**
     * 获取：优惠券标题
     */
    public String getCouponTitle() {
        return couponTitle;
    }
    /**
     * 设置：优惠券减免价格
     */
    public void setCouponPrice(BigDecimal couponPrice) {
        this.couponPrice = couponPrice;
    }

    /**
     * 获取：优惠券减免价格
     */
    public BigDecimal getCouponPrice() {
        return couponPrice;
    }
    /**
     * 设置：手续费
     */
    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    /**
     * 获取：手续费
     */
    public BigDecimal getFee() {
        return fee;
    }
    /**
     * 设置：交易号
     */
    public void setPayId(String payId) {
        this.payId = payId;
    }

    /**
     * 获取：交易号
     */
    public String getPayId() {
        return payId;
    }
    /**
     * 设置：支付状态，0未支付，1已支付
     */
    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    /**
     * 获取：支付状态，0未支付，1已支付
     */
    public Integer getPayStatus() {
        return payStatus;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Integer getEnableFlag() {
        return enableFlag;
    }

    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }
}
