package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfOrderService;
import com.diaoyun.zion.chinafrica.vo.TbCfOrderVo;
import com.diaoyun.zion.master.base.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Controller
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Api(tags = "订单")
@RestController
@RequestMapping("/order")
public class TbCfOrderController {
    @Autowired
    private TbCfOrderService tbCfOrderService;

    @ApiOperation("用户结算，返回订单")
    @GetMapping("/settle")
    public Result<TbCfOrderVo> settleAccount(@ApiParam("发放ID") @RequestParam(value = "iss_coupon_id",required = false) String iss_coupon_id) throws IOException, URISyntaxException, ExecutionException, InterruptedException, TimeoutException {
        return tbCfOrderService.settleAccount(iss_coupon_id);
    }

    @ApiOperation("用户确定下单")
    @PostMapping("/place")
    public Result placeOrder(@ApiParam("订单详情") @RequestBody TbCfOrderVo tbCfOrderVo,@ApiParam("发放ID") @RequestParam(value = "iss_coupon_id",required = false) String iss_coupon_id) throws IOException, URISyntaxException, ExecutionException, InterruptedException, TimeoutException {
        System.out.println("发放Id"+iss_coupon_id);
        return tbCfOrderService.placeOrder(tbCfOrderVo,iss_coupon_id);
    }

    /**
     * pageNum 页数
     * pageSize 每页大小
     */
    @ApiOperation("获取用户订单 默认10条")
    @GetMapping
    public Result<PageInfo> getUserOrderList(@ApiParam(value = "页数") @RequestParam(required = false) Integer pageNum,
                                             @ApiParam(value ="每页大小") @RequestParam(required = false) Integer pageSize,
                                             @ApiParam(value = "订单状态") @RequestParam(required = false)Integer orderStatus) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        return tbCfOrderService.getUserOrderList(pageNum, pageSize,orderStatus);
    }

    @ApiOperation("获取stripe公钥")
    @GetMapping("/stripe")
    public Result<String> getStripePublicKey() {
        return tbCfOrderService.getStripePublicKey();
    }

    @ApiOperation("发起订单支付")
    @PostMapping("/pay/{orderId}/{token}")
    public Result payForOrder(@ApiParam("订单id")@PathVariable("orderId")String orderId,@ApiParam("支付token")@PathVariable("token")String token) {
        return tbCfOrderService.payForOrder(orderId,token);
    }

    @ApiOperation("根据订单id，查询物流详情")
    @GetMapping("/express/{orderId}")
    public Result queryOrderExpressInfo(@ApiParam("订单id")@PathVariable String orderId) throws IOException {
        return  tbCfOrderService.queryOrderExpressInfo(orderId);
    }

    @ApiOperation("删除订单")
    @DeleteMapping("/{orderId}")
    public Result deleteOrder(@ApiParam("订单id") @PathVariable String orderId) {
        return  tbCfOrderService.deleteOrder(orderId);
    }

    /**
     * 根据订单号获取详细订单数据
     */
    @ApiOperation(value = "根据订单号获取详细订单数据")
    @GetMapping(value ="/detail/{orderId}")
    public Result getOrderDetail(@PathVariable("orderId")String orderId) {
        return tbCfOrderService.getOrderDetail(orderId);
    }
}
