package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.ShopifyService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.config.DomainProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: wudepeng
 * @Date: 2019/11/15
 * @Description: 调用shopify API，获取商品信息
 */
@Api(tags = "获取shopify的商品信息")
@RestController
@RequestMapping("/shopify")
public class ShopifyController {

    @Autowired
    private ShopifyService shopifyService;

    /**
     * 查询商品
     *
     * @return
     */
    @ApiOperation(value = "查询商品")
    @GetMapping("/queryproducts")
    public Result queryShopifyProducts() {

        return shopifyService.queryShopifyProducts();
    }

    /**
     * 查询分类商品
     *
     * @param product_type
     * @return
     */
    @ApiOperation(value = "查询分类商品")
    @GetMapping("/queryproductsbytype")
    public Result queryProductsByType(@ApiParam("商品分类") @RequestParam("product_type") String product_type,
                                      @ApiParam("商品分类") @RequestParam(value = "product_id", required = false) String product_id) {

        return shopifyService.queryProductsByType(product_type, product_id);
    }

}
