package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.PayPalService;
import com.diaoyun.zion.chinafrica.vo.PayPalResult;
import com.diaoyun.zion.master.base.Result;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.paypal.api.PayPalConfigStorage;
import com.egzosn.pay.paypal.api.PayPalPayService;
import com.egzosn.pay.paypal.bean.PayPalTransactionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;


/**
 * PayPal支付
 */
@RestController
@RequestMapping("/paypal")
public class PayPalController {

    @Autowired
    private PayPalService payPalService;

    /**
     * 发起支付
     *
     * @param orderId
     * @return
     */
    @PostMapping("/pay")
    public Result payForOrder(@RequestParam("orderId") String orderId) {

        return payPalService.payForOrder(orderId);
    }

    /**
     * 支付成功的回调
     *
     * @param request
     * @return
     */
    @GetMapping("/success")
    public Result payForSuccess(HttpServletRequest request) {

        return payPalService.payForSuccess(request);
    }


    /**
     * 取消支付
     *
     * @return
     */
    @GetMapping("/cancel")
    public Result cancelPay() {

        return new Result().setMessage("订单支付已取消");
    }

    /**
     * 退款
     * @param orderId
     * @param payId
     * @return
     */
    @GetMapping("/refund")
    public Result refund(@RequestParam("payId") String payId,@RequestParam("orderId") String orderId) {
        return payPalService.refund(payId, orderId);
    }

}
