package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * ZaraHome 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("zaraHomeSpider")
public class ZaraHomeSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraHomeSpider.class);

    /**
     * ZaraHome 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        Matcher matcher = Pattern.compile("p\\d+").matcher(targetUrl);
        matcher.find();
        String pId = matcher.group().substring(1);
        targetUrl = "https://www.zarahome.cn/itxrest/2/catalog/store/85009928/80290014/category/0/product/" + pId + "/detail";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ZARAHOME.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化 Zara 返回数据
     * @param dataMap 主要的 json 数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(false);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        itemInfo.setShopName("ZaraHome");
        itemInfo.setItemId(pId);
        itemInfo.setShopUrl("https://www.zarahome.cn/");
        itemInfo.setTitle(dataMap.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        List<Double> priceList = new ArrayList<>();
        // 取 colors 节点数组
        JSONArray colorsArr = dataMap.getJSONObject("detail").getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            // 取 detailImagesArr 节点数组第一个对象
            JSONObject imageObj = colorsObj.getJSONObject("image");

            String colorNo = colorsObj.getString("id");
            String color = colorsObj.getString("name");
            String imageUrl = "https://static.zarahome.cn/8/photos4"
                    + imageObj.getString("url")
                    + "_1_1_2.jpg?t="
                    + imageObj.getString("timestamp");

            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }

            //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imageUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            // 取 sizes 节点数组
            JSONArray sizesArr = colorsArr.getJSONObject(i).getJSONArray("sizes");
            for (int j = 0; j < sizesArr.size(); j++) {
                JSONObject sizesObj = sizesArr.getJSONObject(j);

                ///////////////////////// 获取商品尺码属性 ////////////////////
                String sizeNo = sizesObj.getString("sku");
                String size = sizesObj.getString("name");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 库存对应的id(Zara 中以颜色id + 尺码id)
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                String fullPrice = sizesObj.getString("price");
                BigDecimal priceOld=new BigDecimal(fullPrice);
                BigDecimal div = new BigDecimal("100");
                BigDecimal priceNew = priceOld.divide(div, 2, BigDecimal.ROUND_DOWN);
                fullPrice = exchangeRate(priceNew.toString());
                priceList.add(Double.valueOf(fullPrice));

                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setPrice(fullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }
        // 取存储的价格的最大值与最小值
        Double minPrice = Collections.min(priceList);
        Double maxPrice = Collections.max(priceList);
        productResponse.setSalePrice(minPrice + "-" + maxPrice);

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("ZaraHome");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
