package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.SpiderUtil;
import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Prada(普拉达) 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("pradaSpider")
public class PradaSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Prada(普拉达) 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.PRADA.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     *
     * TODO 存在无法爬取数据的问题
     *
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 解析为 Document 对象
        Document document = Jsoup.parse(content);

        Elements pdpNameEle = document.select("div[class=col-xs-12 col-sm-12 pdp-name]");

        // 获取价格
        String fullPrice = pdpNameEle.select("p[class=pdp-price]").text();
        fullPrice = SpiderUtil.retainNumber(fullPrice);
        fullPrice = SpiderUtil.exchangeRate(fullPrice);

        //////////////////////////////////// 获取商品基本信息 //////////////////////////////////////////////////
        itemInfo.setShopName("Prada");
        itemInfo.setShopUrl("https://www.prada.com/");
        itemInfo.setItemId(pdpNameEle.select("div[class=pdp-sku]").text());
        itemInfo.setTitle(pdpNameEle.select("h1").text());
        //////////////////////////////////// 获取商品基本信息End ///////////////////////////////////////////////

        //////////////////////////////////// 获取商品颜色属性 //////////////////////////////////////////////////
        Elements colorEle = document.select("div[class=stiky-style-images]").select("a");
        Elements sizeEle = document.select("div[class=product-size]").select("ul").select("li");

        itemInfo.setPic(colorEle.select("img[class=img-style selected]").attr("src"));
        for (Element colorElement : colorEle) {

            String colorNo = colorElement.attr("data-part-number");
            String imgUrl = colorElement.select("img").attr("src");

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropName(colorNo);
            productPropColor.setPropId(colorNo);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            for (Element sizeElement : sizeEle) {

                String sizeNo = sizeElement.select("input").attr("data-unique-id");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(sizeElement.select("p[class=number]").text());
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                //////////////////////////////////// 获取库存与原始价 ////////////////////////////////////////////
                // 设置库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                // 设置：商品包含库存信息
                ProductSkuStock productSkuStock = new ProductSkuStock();
                OriginalPrice originalPrice = new OriginalPrice();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                productSkuStock.setSellableQuantity(999);
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);

                // TODO 转换汇率，目前商品单位是人民币
                String originalFullPrice = fullPrice;
                originalPrice.setPrice(originalFullPrice);
                productResponse.setPrice(originalFullPrice);
                productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取库存与原始价 END///////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Prada");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
