package com.diaoyun.zion;


import com.alibaba.fastjson.JSON;
import com.diaoyun.zion.chinafrica.vo.Products;
import com.diaoyun.zion.chinafrica.vo.ShopifyConstant;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.ListUtil;
import com.github.pagehelper.PageInfo;
import com.google.gson.JsonArray;
import io.swagger.models.auth.In;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.junit.Test;
import springfox.documentation.spring.web.json.Json;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.*;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 微信
 *
 * @author egan
 * @email egzosn@gmail.com
 * @date 2017/8/18
 */
public class PayTest {

    @Test
    public void test() throws IOException {
        Map<String, Object> params = new HashMap<>();
        params.put("fields", "product_type");
        String connection = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        List list = new ArrayList();
        JSONArray products = JSONObject.fromObject(connection).getJSONArray("products");
        for (int i = 0; i < products.size(); i++) {
            String string = products.getString(i);
            JSONObject jsonObject = JSONObject.fromObject(string);
            String product_type = jsonObject.getString("product_type");
            if (!"".equals(product_type) && !list.contains(product_type)) {
                list.add(product_type);
            }
        }
        System.out.println(list);

    }

    @Test
    public void test1() throws IOException {
        Result result = new Result();
        Map<String, Object> params = new HashMap<>();
        params.put("product_type", "Christmas");
        params.put("limit","1");
        //params.put("since_id", "4248995594337");
        List list = new ArrayList<>();

        String data = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        JSONArray products = JSONObject.fromObject(data).getJSONArray("products");
        for (int i=0;i<products.size();i++){
            Products product = JSON.parseObject(data, Products.class);
            System.out.println(products);
        }
    }

    @Test
    public void test3() {
        Integer count = 0;
        while (count < 4) {
            System.out.println("helloworld!");
            count++;
        }
    }



    public static List<String> pageBySubList(List list, int pagesize, int currentPage) {
        int totalcount = list.size();
        int pagecount = 0;
        List<String> subList;
        int m = totalcount % pagesize;
        if (m > 0) {
            pagecount = totalcount / pagesize + 1;
        } else {
            pagecount = totalcount / pagesize;
        }
        if (m == 0) {
            subList = list.subList((currentPage - 1) * pagesize, pagesize * (currentPage));
        } else {
            if (currentPage == pagecount) {
                subList = list.subList((currentPage - 1) * pagesize, totalcount);
            } else {
                subList = list.subList((currentPage - 1) * pagesize, pagesize * (currentPage));
            }
        }
        return subList;
    }

    @Test
    public void url() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
        String url="http://www.oschina.net/search?scope=bbs&q=C%E8%AF%AD%E8%A8%80";
        String targetUrl= URLDecoder.decode(url, "utf-8");
        Map<String, String> paramMap = HttpClientUtil.getParamMap(targetUrl);
        System.out.println(paramMap);
        String q = URLDecoder.decode(paramMap.get("q"), "utf-8");
        System.out.println(q);

    }

}
