$(function () {
    $("#jqGrid").Grid({
        url: '../tbcftakecoupon/list',
        colModel: [
			{label: '领取id', name: 'takeId', index: 'take_id', width: 80,hidden: true},
			{label: 'userId', name: 'userId', index: 'user_id', key: true, hidden: true},
			{label: '优惠券id', name: 'couponId', index: 'coupon_id', width: 80, hidden: true},
			{label: '优惠券类型', name: 'couponCategoryName', index: 'couponCategoryName', width: 80},
			{label: '优惠券名称', name: 'couponTitle', index: 'couponTitle', width: 80},
			{label: '用户昵称', name: 'nick', index: 'nick', width: 80},
			{label: '领取时间', name: 'createTime', index: 'create_time', width: 80},
			{label: '是否已经使用', name: 'enableFlag', index: 'enable_flag', width: 80,formatter:yesOrNoFormat}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfTakeCoupon: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfTakeCoupon = {};
		},
		update: function (event) {
            let userId = getSelectedRow("#jqGrid");
			if (userId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(userId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfTakeCoupon.userId == null ? "../tbcftakecoupon/save" : "../tbcftakecoupon/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfTakeCoupon),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let userIds = getSelectedRows("#jqGrid");
			if (userIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcftakecoupon/delete",
                    params: JSON.stringify(userIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(userId){
            Ajax.request({
                url: "../tbcftakecoupon/info/"+userId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfTakeCoupon = r.tbCfTakeCoupon;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});