$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfplatform/list',
        colModel: [
			{label: 'platformId', name: 'platformId', index: 'platform_id', key: true, hidden: true},
			{label: '平台编号', name: 'platformCode', index: 'platform_code', width: 80},
			{label: '平台名字', name: 'platformName', index: 'platform_name', width: 80},
			{label: '平台简介', name: 'platformBrief', index: 'platform_brief', width: 80},
			{label: '平台链接', name: 'platformUrl', index: 'platform_url', width: 80,formatter:linkFormat},
			{label: '平台图片', name: 'platformImg', index: 'platform_img', width: 80,formatter:imageFormat},
			{label: '启用状态', name: 'enableFlag', index: 'enable_flag', width: 80},
			{label: '排序(倒序)', name: 'sort', index: 'sort', width: 80},
			{label: '创建日期', name: 'createTime', index: 'create_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfPlatform: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfPlatform = {};
		},
		update: function (event) {
            let platformId = getSelectedRow("#jqGrid");
			if (platformId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(platformId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfPlatform.platformId == null ? "../tbcfplatform/save" : "../tbcfplatform/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfPlatform),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let platformIds = getSelectedRows("#jqGrid");
			if (platformIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfplatform/delete",
                    params: JSON.stringify(platformIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(platformId){
            Ajax.request({
                url: "../tbcfplatform/info/"+platformId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfPlatform = r.tbCfPlatform;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        },tirggerFile : function (event) {
			var file = event.target.files[0];
			var formData = new FormData();
			formData.append("file",file);
			$.ajax({
				url: "../api/upload/image/",
				type: "POST",
				data:formData,
				cache:false,         //不设置缓存
				processData: false,  // 不处理数据
				contentType: false,// 不设置内容类型
				success: function (result) {
					result=JSON.parse(result);
					//console.log(result)
					if (result.errno == 0) {//成功
						vm.tbCfPlatform.platformImg=result.data;
						vm.$forceUpdate();
					} else {
						iview.Message.error(result.errmsg);
					}
				}
			});
		}
	}
});