$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfitemdetail/list',
        colModel: [
			{label: 'itemId', name: 'itemId', index: 'item_id', key: true, hidden: true},
			{label: '商品id，源平台的id，不一定有', name: 'sourceItemId', index: 'source_item_id', width: 80},
			{label: '来源站点id', name: 'stationId', index: 'station_id', width: 80},
			{label: '站点类型 1为商品独立站 2为店铺独立站 3为平台独立站', name: 'stationType', index: 'station_type', width: 80},
			{label: '商品名称', name: 'itemTitle', index: 'item_title', width: 80},
			{label: '商品数量', name: 'itemNum', index: 'item_num', width: 80},
			{label: '商品主图', name: 'itemImg', index: 'item_img', width: 80},
			{label: '商品单价', name: 'itemPrice', index: 'item_price', width: 80},
			{label: '商品分类', name: 'itemCategory', index: 'item_category', width: 80},
			{label: '商品skus', name: 'itemSku', index: 'item_sku', width: 80},
			{label: '所属平台id', name: 'shopId', index: 'shop_id', width: 80},
			{label: '所属平台名', name: 'shopName', index: 'shop_name', width: 80},
			{label: '所属商铺链接', name: 'shopUrl', index: 'shop_url', width: 80},
			{label: '加入时间', name: 'createTime', index: 'create_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfItemDetail: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfItemDetail = {};
		},
		update: function (event) {
            let itemId = getSelectedRow("#jqGrid");
			if (itemId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(itemId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfItemDetail.itemId == null ? "../tbcfitemdetail/save" : "../tbcfitemdetail/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfItemDetail),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let itemIds = getSelectedRows("#jqGrid");
			if (itemIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfitemdetail/delete",
                    params: JSON.stringify(itemIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(itemId){
            Ajax.request({
                url: "../tbcfitemdetail/info/"+itemId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfItemDetail = r.tbCfItemDetail;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});