$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfcontact/list',
        colModel: [
			{label: 'contactId', name: 'contactId', index: 'contact_id', key: true, hidden: true},
			{label: '联系方式', name: 'contactWay', index: 'contact_way', width: 80},
			{label: '联系详情', name: 'contactDetail', index: 'contact_detail', width: 80},
			{label: '是否有效', name: 'enableFlag', index: 'enable_flag', width: 80,formatter:yesOrNoFormat}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfContact: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfContact = {};
		},
		update: function (event) {
            let contactId = getSelectedRow("#jqGrid");
			if (contactId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(contactId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfContact.contactId == null ? "../tbcfcontact/save" : "../tbcfcontact/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfContact),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let contactIds = getSelectedRows("#jqGrid");
			if (contactIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfcontact/delete",
                    params: JSON.stringify(contactIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(contactId){
            Ajax.request({
                url: "../tbcfcontact/info/"+contactId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfContact = r.tbCfContact;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});