package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfTakeCouponDao;
import com.diaoyun.zion.chinafrica.entity.TbCfTakeCouponEntity;
import com.diaoyun.zion.chinafrica.service.TbCfTakeCouponService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 用户领取优惠券列表Service实现类
 *
 * @author lipengjun
 * @date 2019-08-29 11:33:33
 */
@Service("tbCfTakeCouponService")
public class TbCfTakeCouponServiceImpl implements TbCfTakeCouponService {
    @Autowired
    private TbCfTakeCouponDao tbCfTakeCouponDao;

    @Override
    public TbCfTakeCouponEntity queryObject(String takeId) {
        return tbCfTakeCouponDao.queryObject(takeId);
    }

    @Override
    public List<TbCfTakeCouponEntity> queryList(Map<String, Object> map) {
        return tbCfTakeCouponDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfTakeCouponDao.queryTotal(map);
    }

    @Override
    public int save(TbCfTakeCouponEntity tbCfTakeCoupon) {
        tbCfTakeCoupon.setTakeId(IdUtil.createIdbyUUID());
        return tbCfTakeCouponDao.save(tbCfTakeCoupon);
    }

    @Override
    public int update(TbCfTakeCouponEntity tbCfTakeCoupon) {
        return tbCfTakeCouponDao.update(tbCfTakeCoupon);
    }

    @Override
    public int delete(String takeId) {
        return tbCfTakeCouponDao.delete(takeId);
    }

    @Override
    public int deleteBatch(String[] takeIds) {
        return tbCfTakeCouponDao.deleteBatch(takeIds);
    }
}
