package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfHomePageDao;
import com.diaoyun.zion.chinafrica.entity.TbCfHomePageEntity;
import com.diaoyun.zion.chinafrica.service.TbCfHomePageService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.Map;

/**
 * 启动页Service实现类
 *
 * @author lipengjun
 * @date 2019-09-16 18:21:16
 */
@Service("tbCfHomePageService")
public class TbCfHomePageServiceImpl implements TbCfHomePageService {
    @Autowired
    private TbCfHomePageDao tbCfHomePageDao;

    @Override
    public TbCfHomePageEntity queryObject(String pageId) {
        return tbCfHomePageDao.queryObject(pageId);
    }

    @Override
    public List<TbCfHomePageEntity> queryList(Map<String, Object> map) {
        return tbCfHomePageDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfHomePageDao.queryTotal(map);
    }

    @Override
    public int save(TbCfHomePageEntity tbCfHomePage) {
        tbCfHomePage.setPageId(IdUtil.createIdbyUUID());
        return tbCfHomePageDao.save(tbCfHomePage);
    }

    @Override
    public int update(TbCfHomePageEntity tbCfHomePage) {
        return tbCfHomePageDao.update(tbCfHomePage);
    }

    @Override
    public int delete(String pageId) {
        return tbCfHomePageDao.delete(pageId);
    }

    @Override
    public int deleteBatch(String[] pageIds) {
        return tbCfHomePageDao.deleteBatch(pageIds);
    }

    @Override
    public Result getStartPageImage() {
        List<TbCfHomePageEntity> homePageList=tbCfHomePageDao.getStartPageImage();
        return new Result<>(homePageList).setMessage("images of start page");
    }
}
