package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfExpCatRelDao;
import com.diaoyun.zion.chinafrica.entity.TbCfExpCatRelEntity;
import com.diaoyun.zion.chinafrica.service.TbCfExpCatRelService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 快递模板与商品种类关联表Service实现类
 *
 * @author lipengjun
 * @date 2019-08-30 09:47:20
 */
@Service("tbCfExpCatRelService")
public class TbCfExpCatRelServiceImpl implements TbCfExpCatRelService {
    @Autowired
    private TbCfExpCatRelDao tbCfExpCatRelDao;

    @Override
    public TbCfExpCatRelEntity queryObject(String relateId) {
        return tbCfExpCatRelDao.queryObject(relateId);
    }

    @Override
    public List<TbCfExpCatRelEntity> queryList(Map<String, Object> map) {
        return tbCfExpCatRelDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfExpCatRelDao.queryTotal(map);
    }

    @Override
    public int save(TbCfExpCatRelEntity tbCfExpCatRel) {
        tbCfExpCatRel.setRelateId(IdUtil.createIdbyUUID());
        return tbCfExpCatRelDao.save(tbCfExpCatRel);
    }

    @Override
    public int update(TbCfExpCatRelEntity tbCfExpCatRel) {
        return tbCfExpCatRelDao.update(tbCfExpCatRel);
    }

    @Override
    public int delete(String relateId) {
        return tbCfExpCatRelDao.delete(relateId);
    }

    @Override
    public int deleteBatch(String[] relateIds) {
        return tbCfExpCatRelDao.deleteBatch(relateIds);
    }

    @Override
    public Result buildRelate(String tempalteId, String[] categoryIds) {
        List<TbCfExpCatRelEntity>tbCfExpCatRelList=new ArrayList<>();
        for(String categoryId:categoryIds) {
            TbCfExpCatRelEntity tbCfExpCatRelEntity = new TbCfExpCatRelEntity();
            tbCfExpCatRelEntity.setRelateId(IdUtil.createIdbyUUID());
            tbCfExpCatRelEntity.setCategoryId(categoryId);
            tbCfExpCatRelEntity.setCreatTime(new Date());
            tbCfExpCatRelEntity.setTemplateId(tempalteId);
            tbCfExpCatRelList.add(tbCfExpCatRelEntity);
        }
        int res=tbCfExpCatRelDao.buildRelate(tbCfExpCatRelList);
        if(res>0) {
            return new Result(ResultCodeEnum.SUCCESS.getDesc());
        } else {
            return new Result().setCode(ResultCodeEnum.ERROR.getCode()).setMessage(ResultCodeEnum.DAO_ERROR.getDesc());
        }

    }
}
