package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfTaxEntity;

import java.util.List;
import java.util.Map;

/**
 * 税费管理Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfTaxService {

    /**
     * 根据主键查询实体
     *
     * @param taxId 主键
     * @return 实体
     */
    TbCfTaxEntity queryObject(String taxId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfTaxEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfTax 实体
     * @return 保存条数
     */
    int save(TbCfTaxEntity tbCfTax);

    /**
     * 根据主键更新实体
     *
     * @param tbCfTax 实体
     * @return 更新条数
     */
    int update(TbCfTaxEntity tbCfTax);

    /**
     * 根据主键删除
     *
     * @param taxId
     * @return 删除条数
     */
    int delete(String taxId);

    /**
     * 根据主键批量删除
     *
     * @param taxIds
     * @return 删除条数
     */
    int deleteBatch(String[] taxIds);
}
