package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfGoodstypeEntity;


import java.util.List;
import java.util.Map;

/**
 * Service接口
 *
 * @author lipengjun
 * @date 2019-10-08 16:34:40
 */
public interface TbCfGoodstypeService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfGoodstypeEntity queryObject(String goodstypeId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfGoodstypeEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfGoodstype 实体
     * @return 保存条数
     */
    int save(TbCfGoodstypeEntity tbCfGoodstype);

    /**
     * 根据主键更新实体
     *
     * @param tbCfGoodstype 实体
     * @return 更新条数
     */
    int update(TbCfGoodstypeEntity tbCfGoodstype);

    /**
     * 根据主键删除
     *
     * @param goodstypeId
     * @return 删除条数
     */
    int delete(String goodstypeId);

    /**
     * 根据主键批量删除
     *
     * @param goodstypeIds
     * @return 删除条数
     */
    int deleteBatch(String[] goodstypeIds);
}
