package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfContactEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 联系管理Service接口
 *
 * @author lipengjun
 * @date 2019-09-17 18:03:40
 */
public interface TbCfContactService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfContactEntity queryObject(String contactId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfContactEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfContact 实体
     * @return 保存条数
     */
    int save(TbCfContactEntity tbCfContact);

    /**
     * 根据主键更新实体
     *
     * @param tbCfContact 实体
     * @return 更新条数
     */
    int update(TbCfContactEntity tbCfContact);

    /**
     * 根据主键删除
     *
     * @param contactId
     * @return 删除条数
     */
    int delete(String contactId);

    /**
     * 根据主键批量删除
     *
     * @param contactIds
     * @return 删除条数
     */
    int deleteBatch(String[] contactIds);

    /**
     * 获取有效的联系方式
     * @return
     */
    Result getContactList();
}
