package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfAddressEntity;
import com.diaoyun.zion.chinafrica.vo.TbCfAddressVo;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * Service接口
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
public interface TbCfAddressService {

    /**
     * 根据主键查询实体
     *
     * @param addressId 主键
     * @return 实体
     */
    TbCfAddressEntity queryObject(String addressId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfAddressEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfAddress 实体
     * @return 保存条数
     */
    int save(TbCfAddressEntity tbCfAddress);

    /**
     * 根据主键更新实体
     *
     * @param tbCfAddress 实体
     * @return 更新条数
     */
    int update(TbCfAddressEntity tbCfAddress);

    /**
     * 根据主键删除
     *
     * @param addressId
     * @return 删除条数
     */
    int delete(String addressId);

    /**
     * 根据主键批量删除
     *
     * @param addressIds
     * @return 删除条数
     */
    int deleteBatch(String[] addressIds);

    /**
     * 新增地址
     * @param tbCfAddressVo
     * @return
     */
    TbCfAddressVo saveAddress(TbCfAddressVo tbCfAddressVo);

    /**
     * 修改地址
     * @param tbCfAddressVo
     * @return
     */
    TbCfAddressVo updateAddress(TbCfAddressVo tbCfAddressVo);


    /**
     * 获取用户地址列表
     * @return
     */
    List<TbCfAddressVo> getUserInfoList();

    /**
     * 设置为默认地址
     * @param addressId
     * @return
     */
    int configDefaultAddress(String addressId);

    /**
     * 获取用户默认地址
     * @return
     */
    Result getDefaultAddress();

    /**
     * 根据地址id获取详细地址
     * @param addressId
     * @return
     */
    Result getAddressDetailById(String addressId);
}
