package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfCartRecordRService;
import com.diaoyun.zion.chinafrica.service.TbCfItemDetailService;
import com.diaoyun.zion.chinafrica.vo.TbCfCartItemDetailVo;
import com.diaoyun.zion.chinafrica.vo.TbCfItemDetailVo;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 商品详情Controller
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@Api(tags = "商品相关")
@RestController
@RequestMapping("/item")
public class TbCfItemDetailController {
    @Autowired
    private TbCfItemDetailService tbCfItemDetailService;
    @Autowired
    private HttpServletRequest request; //自动注入request
    @Autowired
    private TbCfCartRecordRService tbCfCartRecordRService;


    @ApiOperation("加入到购物车")
    @PostMapping("/cart")
    public Result addToCart(@ApiParam("商品详情") @RequestBody TbCfItemDetailVo tbCfItemDetailVo) throws InterruptedException, ExecutionException, TimeoutException {
        return tbCfItemDetailService.addToCart(tbCfItemDetailVo);
    }

    @ApiOperation("改变购物车的商品勾选状态")
    @PutMapping("/state/{cartRecordId}/{checkFlag}")
    public Result changeItemState(@ApiParam("购物车记录id")@PathVariable ("cartRecordId") String cartRecordId,
                                  @ApiParam("勾选状态 0不选中，1选中")@PathVariable ("checkFlag") Integer checkFlag) {
        return tbCfItemDetailService.changeItemState(cartRecordId,checkFlag);
    }

    @ApiOperation("更改购物车商品数量")
    @PutMapping("/cart/{itemId}/{itemNum}")
    public Result changeItemNum(@ApiParam("商品Id")@PathVariable String itemId,  @ApiParam("商品数量")@PathVariable int itemNum) {
        return tbCfItemDetailService.changeItemNum(itemId,itemNum);
    }

    @ApiOperation("从购物车删除商品")
    @PostMapping("/cart/delete")
    public Result deleteItems(@ApiParam("商品Id数组") @RequestBody String[] cartRecordIds) {
        return tbCfCartRecordRService.deleteItems(cartRecordIds);
    }

    @ApiOperation("获取用户购物车内的商品")
    @GetMapping("/cart")
    public Result<List<TbCfCartItemDetailVo>> getCartItem() {
        List<TbCfCartItemDetailVo> tbCfCartItemDetailList =tbCfItemDetailService.getCartItemList();
        return new Result<>(tbCfCartItemDetailList);
    }

}
