package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * Adidas 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("adidasSpider")
public class AdidasSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * Adidas 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取商品的 id
        final String regex = "\\w+\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(targetUrl);
        matcher.find();
        String pId = matcher.group(0);
         // 对应的商品数据接口
        targetUrl = "https://www.adidas.com.cn/item/othercolor?itemCode=" + pId;
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ADIDAS.getValue());
        ProductResponse productResponse = formatProductResponse(content, pId);
        JSONObject resultJson = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultJson);
        return resultJson;
    }

    /**
     * 格式化返回数据
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content, String pId) throws IOException, URISyntaxException {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 无库存信息
        productResponse.setStockFlag(false);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 解析为 Document 对象
        Document document = Jsoup.parse(content);

        // 获取颜色(型号)
        List<String> colorNoList = document.select("div[class=pdp-color events-color-close]")
                .select("ul").select("li").eachAttr("code");
        // 获取价格
        String fullPrice = document.select("input[id=salePrice]").attr("value");
        String originalFullPrice = exchangeRate(fullPrice);
        // 获取尺码
        List<String> pSizeList = document.select("div[class=overview product-size]")
                .select("ul").select("li").eachText();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("Adidas");
        itemInfo.setShopUrl("https://www.adidas.com");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(document.select("input[id=itemTitle]").attr("value"));
        itemInfo.setPic(document.select("input[id=shoppingcartpic]").attr("value"));
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
        for (String colorNo : colorNoList) {

            String targetUrl = "https://www.adidas.com.cn/item/othercolor?itemCode=" + pId;
            String colorContent = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ADIDAS.getValue());

            Document colorDoc = Jsoup.parse(colorContent);

            String color = colorDoc.select("input[id=colorDisPaly]").attr("value");
            String imgUrl = colorDoc.select("input[id=shoppingcartpic]").attr("value");

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            for (int i = 0; i < pSizeList.size(); i++) {

                ///////////////////////// 获取商品尺码属性 ////////////////////
                String sizeNo = pSizeList.get(i);
                String size = sizeNo;

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 库存对应的id(颜色id + 尺码id)
                String skuStr = ";" + colorNo + ";" + pSizeList.get(i) + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(originalFullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(originalFullPrice);
                productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
                //////////////////////////////////// 获取原始价 END///////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Adidas");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
