package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfIssueCouponDao;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfIssueCouponEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfIssueCouponEntityExtends;
import com.diaoyun.zion.chinafrica.service.TbCfIssueCouponService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 优惠券发放表Service实现类
 *
 * @author lipengjun
 * @date 2019-10-24 17:30:10
 */
@Service("tbCfIssueCouponService")
public class TbCfIssueCouponServiceImpl implements TbCfIssueCouponService {
    @Autowired
    private TbCfIssueCouponDao tbCfIssueCouponDao;

    @Override
    public TbCfIssueCouponEntity queryObject(String couponIssuetableId) {
        return tbCfIssueCouponDao.queryObject(couponIssuetableId);
    }

    @Override
    public List<TbCfIssueCouponEntity> queryList(Map<String, Object> map) {
        return tbCfIssueCouponDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfIssueCouponDao.queryTotal(map);
    }


    @Override
    public int update(TbCfIssueCouponEntity tbCfIssueCoupon) {
        return tbCfIssueCouponDao.update(tbCfIssueCoupon);
    }

    @Override
    public int delete(String couponIssuetableId) {
        return tbCfIssueCouponDao.delete(couponIssuetableId);
    }

    @Override
    public int deleteBatch(String[] couponIssuetableIds) {
        return tbCfIssueCouponDao.deleteBatch(couponIssuetableIds);
    }


    @Override
    public int save(TbCfCouponIssueEntity tbCfCouponIssue, TbCfIssueCouponEntity tbCfIssueCoupon, String userId, String nick) {
        tbCfIssueCoupon.setCouponIssueTableId(IdUtil.createIdbyUUID());
        tbCfIssueCoupon.setCouponId(tbCfCouponIssue.getCouponId());
        tbCfIssueCoupon.setUserId(userId);
        tbCfIssueCoupon.setNick(nick);
        tbCfIssueCoupon.setEnableFlag(1);
        tbCfIssueCoupon.setCreateTime(new Date());
        tbCfIssueCoupon.setIssueId(tbCfCouponIssue.getCouponIssueId());
        return tbCfIssueCouponDao.save(tbCfIssueCoupon);
    }

    public Result<TbCfIssueCouponEntityExtends> queryCouponByUserId(String userId){
        List<TbCfIssueCouponEntityExtends> anExtends = tbCfIssueCouponDao.queryCouponByUserId(userId);
        return new Result<>(anExtends.get(0));
    }
}
