package com.diaoyun.zion.chinafrica.factory;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.SpringContextUtil;

/**
 * 商品爬虫
 */
public class ItemSpiderFactory {

    public static IItemSpider getSpider(PlatformEnum platformEnum) {
        IItemSpider iItemSpider;
        switch (platformEnum.getValue()) {
            case "tb":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("tbItemSpider");
                break;
            }
            case "tm":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("tmItemSpider");
                break;
            }
            case "pullandbear":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("pullandbearSpider");
                break;
            }
            case "gap":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("gapItemSpider");
                break;
            }
            case "zara":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("zaraSpider");
                break;
            }
            case "uniqlo":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("uniqloSpider");
                break;
            }
            case "nike":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("nikeItemSpider");
                break;
            }
            case "adidas":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("adidasSpider");
                break;
            }
            case "hm":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("hmSpider");
                break;
            }
            case "massimodutti":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("massimoduttiSpider");
                break;
            }
            case "afri-eshop":{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("africaShopItemSpider");
                break;
            }
            default:{
                iItemSpider= (IItemSpider) SpringContextUtil.getBean("emptyItemSpider");
                break;
            }
        }
        return iItemSpider;
    }

}
