package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfStationItemEntity;
import com.diaoyun.zion.chinafrica.service.TbCfStationItemService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

/**
 * 站点商品Controller
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Api(tags="商品独立站")
@RestController
@RequestMapping("/itemStation")
public class TbCfStationItemController {
    @Autowired
    private TbCfStationItemService tbCfStationItemService;
    /*
    @ApiOperation("获取商品独立站")
    @GetMapping
    public Result getItemStationList(@ApiParam(value = "页数 默认1") @RequestParam(required = false) Integer pageNum,
                                  @ApiParam(value ="每页大小 默认10") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 2;
        }
        return tbCfStationItemService.getItemStationList(pageNum,pageSize);
    }*/
    @ApiOperation("统计商品点击量")
    @PutMapping("/item/{itemId}")
    @ResponseBody
    public Result updateItemNum(@ApiParam(value ="商品ID") @PathVariable("itemId") String itemId) {
        TbCfStationItemEntity item = tbCfStationItemService.queryObject(itemId);
        if(item!=null){
            Long start=item.getItemNum();
            item.setItemNum(++start);
            int update = tbCfStationItemService.update(item);
            return new Result(update, ResultCodeEnum.SUCCESS.getDesc());
        }
        return new Result(ResultCodeEnum.ERROR.getCode(),ResultCodeEnum.ERROR.getDesc());
    }
}
