package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 西班牙年轻时尚品牌-PullAndBear 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("pullandbearSpider")
public class PullandbearSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * PullAndBear 商品详情链接
     */
    private static final String PULL_AND_BEAR_URL="https://www.pullandbear.cn/itxrest/2/catalog/store/24009528/20309423/category/0/product/";

    /**
     * PullAndBear 数据爬虫
     * @see com.diaoyun.zion.chinafrica.service.impl.SpiderServiceImpl#judgeUrlType 修改商品详情页路径
     * @see SpiderUtil#formatPullAndBearProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String pId = targetUrl.substring(targetUrl.lastIndexOf("p")+1, targetUrl.lastIndexOf(".html"));
        targetUrl = PULL_AND_BEAR_URL + pId + "/detail?languageId=-7&appId=1";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.PULLANDBEAR.getValue());
        JSONObject resultJson = JSONObject.fromObject(content);
        ProductResponse productResponse = SpiderUtil.formatPullAndBearProductResponse(resultJson, pId);
        resultJson = JSONObject.fromObject(productResponse);
        // 翻译
        TranslateHelper.translateProductResponse(resultJson);
        return resultJson;
    }


}


