package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.JsoupUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Massimo Dutti 数据爬虫
 *
 * https://www.massimodutti.cn/cn/%E5%A5%B3%E8%A3%85/corners/denim/%E4%B8%AD%E8%85%B0%E8%8E%B1%E8%B5%9B%E5%B0%94%E6%A3%89%E8%B4%A8%E7%9B%B4%E7%AD%92%E9%95%BF%E8%A3%A4-c1855082p8667556.html?colorId=712&categoryId=1855082
 * https://www.massimodutti.cn/cn/%E5%A5%B3%E8%A3%85/corners/denim/%E4%B8%AD%E8%85%B0%E8%8E%B1%E8%B5%9B%E5%B0%94%E6%A3%89%E8%B4%A8%E7%9B%B4%E7%AD%92%E9%95%BF%E8%A3%A4-c1855082p8667556.html?colorId=712&categoryId=1855082
 *
 * @author 爱酱油不爱醋
 */
@Component("massimoduttiSpider")
public class MassimoduttiSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Massimo Dutti 商品详情页Url
     */
    private static final String MASSIMO_DUTTI_URL = "https://www.massimodutti.cn/cn/";

    /**
     * Massimo Dutti 数据爬虫
     * @see com.diaoyun.zion.chinafrica.service.impl.SpiderServiceImpl#judgeUrlType 修改商品详情页路径
     * @see SpiderUtil#formatMassimoDuttiProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取链接中商品的 id
        String[] split = targetUrl.split(".html");
        String pUrl = split[0];
        int pChar = pUrl.lastIndexOf("p");
        String pId = pUrl.substring(pChar + 1);
        String dataUrl = "https://www.massimodutti.cn/itxrest/2/catalog/store/35009478/30359500/category/0/product/" + pId + "/detail?languageId=-7&appId=1";
        String content = HttpClientUtil.getContentByUrl(dataUrl, PlatformEnum.MASSIMODUTTI.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = SpiderUtil.formatMassimoDuttiProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

}
