package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Adidas 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("adidasSpider")
public class AdidasSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * Adidas 商品详情页连接
     */
    private static final String ADIDAS_URL="https://www.adidas.com.cn/item";

    /**
     * Adidas 数据爬虫
     * @see com.diaoyun.zion.chinafrica.service.impl.SpiderServiceImpl#judgeUrlType 修改商品详情页路径
     * @see SpiderUtil#formatPullAndBearProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {

        JSONObject resultJson = JSONObject.fromObject(targetUrl);
        return resultJson;
    }


    public static void main(String[] args) throws Exception {
        String targetUrl = "";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ADIDAS.getValue());

        System.out.println(content);
    }
}
