package com.diaoyun.zion.master.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

/**
 * ID 生成工具类<br>
 *
 */
public class IdUtil {
    /**
     * 主要功能:生成流水号 yyyyMMddHHmmssSSS + 3位随机数
     * 注意事项:无
     *
     * @return 流水号
     */
    public static String createIdByDate() {
        // 精确到毫秒
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String suffix = fmt.format(new Date());
        suffix = suffix+ Math.round((Math.random() * 100000));
        return suffix;
    }
    /**
     * 主要功能:生成流水号 yyyyMMddHHmmssSSS + 3位随机数
     * 注意事项:不能超出long类型取值范围 9223372036854775807
     *
     * @return 流水号
     */
    public static Long createLongIdByDate() {
        // 精确到毫秒
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String suffix = fmt.format(new Date());
        suffix = suffix+ Math.round((Math.random() * 100));
        return Long.valueOf(suffix);
    }

    /**
     * 主要功能:生成uuid
     * 注意事项:无
     *
     * @return uuid 32 位
     */
    public static String createIdbyUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}
