package com.diaoyun.zion.master.util;

import com.google.common.collect.Lists;
import org.apache.http.*;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpClientUtil {

    /**
     * 获取url链接中的content 网页内容
     * @param url 目标url
     * @return
     * @throws URISyntaxException
     * @throws IOException
     */
    public static String getContentByUrl(String url) throws URISyntaxException, IOException {
        //构建URI
        URI uri=new URIBuilder(url).build();
        //创建一个HttpContext对象，用来保存Cookie
        //HttpClientContext httpClientContext = HttpClientContext.create();
        //构造自定义的HttpClient对象
        CloseableHttpClient httpClient = createBrowserClient();
        /* 构造请求对象 */
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri(uri).build();
        /* ****************获取商品详情链接******************* */
        //执行请求，传入HttpContext，将会得到请求结果的信息
        //httpClient.execute(httpUriRequest,httpClientContext)
        HttpResponse httpResponse=httpClient.execute(httpUriRequest);
        //拿到返回的HttpResponse的"实体"
        HttpEntity result = httpResponse.getEntity();
        String content = EntityUtils.toString(result);
        //关闭连接
        httpClient.close();
        return content;
    }
    /**
     * 获取url链接中的content 网页内容
     * @param url 目标url
     * @return
     * @throws URISyntaxException
     * @throws IOException
     */
    public static String getContentByUrl(String url, BasicHeader basicHeader) throws URISyntaxException, IOException {
        URI sibUri=new URIBuilder(url).build();
        //构造请求对象
        HttpUriRequest sibUriRequest = RequestBuilder.get().setUri(sibUri).build();
        //构造自定义的HttpClient对象
        CloseableHttpClient sibClient = createBrowserClient(basicHeader);
        //创建一个HttpContext对象，用来保存Cookie
        //HttpClientContext sibClientContext = HttpClientContext.create();
        //执行请求，传入HttpContext，将会得到请求结果的信息
        HttpResponse sibResponse=sibClient.execute(sibUriRequest);
        //拿到返回的HttpResponse的"实体"
        HttpEntity sibResult = sibResponse.getEntity();
        String sibContent = EntityUtils.toString(sibResult);
        //unicode 解码
        //关闭连接
        sibClient.close();
        return sibContent;
    }


    /**
     * 创建带浏览器头部的连接
     * @return
     */
    public static CloseableHttpClient createBrowserClient() {
        //构造自定义Header信息
        List<Header> headerList = Lists.newArrayList();
        headerList.add(new BasicHeader(HttpHeaders.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9," +
                "image/webp,image/apng,*/*;q=0.8"));
        headerList.add(new BasicHeader(HttpHeaders.USER_AGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36"));
        headerList.add(new BasicHeader(HttpHeaders.ACCEPT_ENCODING, "gzip, deflate, br"));
        headerList.add(new BasicHeader(HttpHeaders.CACHE_CONTROL, "max-age=0"));
        headerList.add(new BasicHeader(HttpHeaders.CONNECTION, "keep-alive"));
        headerList.add(new BasicHeader(HttpHeaders.ACCEPT_LANGUAGE, "zh-CN,zh;q=0.9"));
        //cookie
        CookieStore cookieStore = new BasicCookieStore();
        return HttpClients.custom().setDefaultHeaders(headerList).setDefaultCookieStore(cookieStore).build();
    }

    /**
     * 创建带浏览器头部的连接
     * @return
     */
    public static CloseableHttpClient createBrowserClient(BasicHeader basicHeader) {
        //构造自定义Header信息
        List<Header> headerList = Lists.newArrayList();
        headerList.add(new BasicHeader(HttpHeaders.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9," +
                "image/webp,image/apng,*/*;q=0.8"));
        headerList.add(new BasicHeader(HttpHeaders.USER_AGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36"));
        headerList.add(new BasicHeader(HttpHeaders.ACCEPT_ENCODING, "gzip, deflate, br"));
        headerList.add(new BasicHeader(HttpHeaders.CACHE_CONTROL, "max-age=0"));
        headerList.add(new BasicHeader(HttpHeaders.CONNECTION, "keep-alive"));
        headerList.add(new BasicHeader(HttpHeaders.ACCEPT_LANGUAGE, "zh-CN,zh;q=0.9"));
        headerList.add(basicHeader);
        //cookie
        CookieStore cookieStore = new BasicCookieStore();
        return HttpClients.custom().setDefaultHeaders(headerList).setDefaultCookieStore(cookieStore).build();
    }

    //发送请求
    public static String createConnection(String url,Map<String, Object> paramMap,String charencode) throws IOException {
        List<NameValuePair> formparams = setHttpParams(paramMap);
        String param = URLEncodedUtils.format(formparams, charencode);
        HttpGet httpGet = new HttpGet();    //构建一个GET请求
        httpGet.setURI(URI.create(url + "?" + param));
        CloseableHttpClient httpClient=createBrowserClient();
        HttpResponse sibResponse=httpClient.execute(httpGet);
        HttpEntity sibResult = sibResponse.getEntity();//拿到返回的HttpResponse的"实体"
        String sibContent = EntityUtils.toString(sibResult);
        return sibContent;
    }

    private static List<NameValuePair> setHttpParams(Map<String, Object> paramsMap) {
        List<NameValuePair> list = new ArrayList<NameValuePair>();
        for (String key : paramsMap.keySet()) {
            list.add(new BasicNameValuePair(key, String.valueOf(paramsMap.get(key))));
        }
        return list;
    }
}
