package com.diaoyun.zion.master.common;

import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.config.DomainProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 分布式环境令牌管理
 * @author G
 */
@Component("redisTokenManager")
public class RedisTokenManager extends TokenManager {

    @Autowired
    private DomainProperties domainProperties;
	@Resource
	private RedisCache<TbCfUserInfoVo> redisCache;

	@Override
	public void addToken(String token, TbCfUserInfoVo loginUser) {
	    String timeStr=domainProperties.getProperty("redis.token.expiredTime");
        long expiredTime=tokenTimeout;
	    if(StringUtils.isNotBlank(timeStr)) {
            expiredTime=Long.valueOf(timeStr);
        }
		redisCache.set(token, loginUser, expiredTime);
	}

	@Override
	public TbCfUserInfoVo validate(String token) {
		TbCfUserInfoVo loginUser = redisCache.get(token);
		if (loginUser != null ) {
			addToken(token, loginUser);
		}
		return loginUser;
	}

	@Override
	public void remove(String token) {
		redisCache.delete(token);
	}

	@Override
	public void verifyExpired() {
	}
}
