package com.diaoyun.zion.master.base;

import com.diaoyun.zion.master.enums.ResponseCodeEnum;
//import com.fasterxml.jackson.annotation.JsonIgnore;

import java.io.Serializable;

//保证序列化json的时候,如果是null的对象,key也会消失
/*
    这里加这个的原因是：
        当登陆失败的话返回的是{
            status : 1
            msg : 密码错误
            而data是一个有key的空节点,即value = null
        }
        这样的话data将不会出现在json之中了。
补充：
将该标记放在属性上，如果该属性为NULL则不参与序列化
如果放在类上边,那对这个类的全部属性起作用
Include.Include.ALWAYS 默认
Include.NON_DEFAULT 属性为默认值不序列化
Include.NON_EMPTY 属性为 空（“”） 或者为 NULL 都不序列化
Include.NON_NULL 属性为NULL 不序列化 。
 */
//@JsonSerialize(include =  JsonSerialize.Inclusion.NON_NULL)
public class ServerResponse<T> implements Serializable {

    private int status;   //状态
    private String msg;   //信息
    private T data;       //数据

    //定义4个构造方法
    //1
    private ServerResponse(int status) {
        this.status = status;
    }
    //2
    private ServerResponse(int status,T data){
        this.status = status;
        this.data = data;
    }
    //3
    private ServerResponse(int status,String msg,T data){
        this.status = status;
        this.msg = msg;
        this.data = data;
    }
    //4
    private ServerResponse(int status,String msg){
        this.status = status;
        this.msg = msg;
    }

    //@JsonIgnore
    //使之不在json序列化结果当中
    //即json里面不会出现这个
    public boolean isSuccess(){
        //如果status == 0 则返回true
        //SUCCESS的枚举值为0
        return this.status == ResponseCodeEnum.SUCCESS.getCode();
    }
    //返回状态
    public int getStatus(){
        return status;
    }
    public T getData(){
        return data;
    }
    public String getMsg(){
        return msg;
    }
    //调用status构造器
    public static <T> ServerResponse<T> createBySuccess(){
        return new ServerResponse<T>(ResponseCodeEnum.SUCCESS.getCode());
    }
    //调用4号构造器
    public static <T> ServerResponse<T> createBySuccessMessage(String msg){
        return new ServerResponse<T>(ResponseCodeEnum.SUCCESS.getCode(),msg);
    }

    public static <T> ServerResponse<T> createBySuccess(T data){
        return new ServerResponse<T>(ResponseCodeEnum.SUCCESS.getCode(),data);
    }

    public static <T> ServerResponse<T> createBySuccess(String msg,T data){
        return new ServerResponse<T>(ResponseCodeEnum.SUCCESS.getCode(),msg,data);
    }

    public static <T> ServerResponse<T> createByError(){
        return new ServerResponse<T>(ResponseCodeEnum.ERROR.getCode(),ResponseCodeEnum.ERROR.getDesc());
    }

    public static <T> ServerResponse<T> createByErrorMessage(String errorMessage){
        return new ServerResponse<T>(ResponseCodeEnum.ERROR.getCode(),errorMessage);
    }

    public static <T> ServerResponse<T> createByErrorCodeMessage(int errorCode,String errorMessage){
        return new ServerResponse<T>(errorCode,errorMessage);
    }
}

