package com.diaoyun.zion.master.base;



import java.io.Serializable;

/**
 * 返回结果
 *
 * @author Joe
 */
public class Result<T> implements Serializable {

    /**
     * 结果体
     */
    protected T data;

    /**
     * 状态码
     */
    protected Integer code;

    /**
     * 信息
     */
    protected String message;

    /**
     * code 默认成功
     */
    public Result() {
        this.code = ResultCode.SUCCESS;
    }

    public Result(Integer code) {
        this.code = code;
    }


    /**
     * code 默认成功
     * @param message
     */
    public Result(String message) {
        this.code = ResultCode.SUCCESS;
        this.message = message;
    }

    /**
     * code 默认成功
     * @param data
     */
    public Result(T data) {
        this.code = ResultCode.SUCCESS;
        this.data = data;
    }

    public Result(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * code 默认成功
     * @param data
     * @param message
     */
    public Result(T data, String message) {
        this.code = ResultCode.SUCCESS;
        this.data = data;
        this.message = message;
    }

    /**
     *
     * @param data
     * @param code ResultCode
     * @param message
     */
    public Result(T data, Integer code, String message) {
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public Result setData(T data) {

        this.data = data;
        return this;
    }

    public Integer getCode() {
        return code;
    }

    public Result setCode(Integer code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public Result setMessage(String message) {
        this.message = message;
        return this;
    }
}
