package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.client.SessionUser;
import com.diaoyun.zion.chinafrica.client.SessionUtils;
import com.diaoyun.zion.chinafrica.constant.EmailTemplateConstant;
import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.dao.TbCfUserInfoDao;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.ResultCode;
import com.diaoyun.zion.master.base.StateConstant;
import com.diaoyun.zion.master.bo.EmailTemplateBo;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.config.DomainProperties;
import com.diaoyun.zion.master.enums.SexEnum;
import com.diaoyun.zion.master.enums.TrueFalseEnum;
import com.diaoyun.zion.master.enums.UserTypeEnum;
import com.diaoyun.zion.master.exception.ValidateException;
import com.diaoyun.zion.master.util.*;
import com.diaoyun.zion.master.validator.Validator;
import freemarker.template.TemplateException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 用户表Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:47
 */
@Service("tbCfUserInfoService")
public class TbCfUserInfoServiceImpl implements TbCfUserInfoService {
    @Autowired
    private TbCfUserInfoDao tbCfUserInfoDao;

    @Resource(name = "redisTokenManager")
    private TokenManager tokenManager;

    @Autowired
    private EmailHelper emailHelper;

    @Autowired
    private DomainProperties domainProperties;

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private HttpServletResponse response;

    @Override
    public TbCfUserInfoEntity queryObject(String userId) {
        return tbCfUserInfoDao.queryObject(userId);
    }

    @Override
    public List<TbCfUserInfoEntity> queryList(Map<String, Object> map) {
        return tbCfUserInfoDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfUserInfoDao.queryTotal(map);
    }

    @Override
    public int save(TbCfUserInfoEntity tbCfUserInfo) {
        tbCfUserInfo.setUserId(IdUtil.createIdbyUUID());
        return tbCfUserInfoDao.save(tbCfUserInfo);
    }

    @Override
    public int update(TbCfUserInfoEntity tbCfUserInfo) {
        return tbCfUserInfoDao.update(tbCfUserInfo);
    }

    @Override
    public int delete(String userId) {
        return tbCfUserInfoDao.delete(userId);
    }

    @Override
    public int deleteBatch(String[] userIds) {
        return tbCfUserInfoDao.deleteBatch(userIds);
    }

    @Override
    public Integer sendRegisterIdentifyCode(String email, String nick) throws EmailException, TemplateException, IOException {
        EmailTemplateBo emailTemplateBo = new EmailTemplateBo();
        Integer randomCode = RandomCodeHelper.producedRandomCode(6);
        emailTemplateBo.setNick(nick);
        emailTemplateBo.setIdentifyCode(randomCode);
        Integer identifyCode = emailHelper.sendIdentifyEmail(email, EmailTemplateConstant.REGISTER, emailTemplateBo);
        return identifyCode;
    }

    @Override
    public Result registerAndLogin(TbCfUserInfoVo tbCfUserInfoVo) {
        Result result = new Result();
        Integer identifyCode = (Integer) request.getSession().getAttribute(KeyConstant.IDENTIFY_CODE);
        if (identifyCode == null || identifyCode.intValue() != tbCfUserInfoVo.getCaptcha().intValue()) {
            result.setCode(ResultCode.VALIDATE_ERROR);
            result.setMessage("验证码错误");
        } else {
            //验证邮箱有没有被注册
            TbCfUserInfoEntity existUser = findByAccount(tbCfUserInfoVo.getEmail());
            if (existUser == null) {
                //验证邮箱格式
                Validator.NOT_BLANK.validate("邮箱", tbCfUserInfoVo.getEmail());

                TbCfUserInfoEntity tbCfUserInfoEntity = new TbCfUserInfoEntity();
                /**
                 * 填充必要信息
                 */
                //目前有验证码的都是邮箱类型
                tbCfUserInfoVo.setUserType(UserTypeEnum.EMAIL.getCode());
                tbCfUserInfoVo.setEmailFlag(StateConstant.VALID);
                fillUserNecessayInfo(tbCfUserInfoVo);
                //加密密码
                String password = PasswordProvider.encrypt(tbCfUserInfoVo.getPassword());
                tbCfUserInfoVo.setPassword(password);
                BeanUtils.copyProperties(tbCfUserInfoVo, tbCfUserInfoEntity);
                tbCfUserInfoDao.save(tbCfUserInfoEntity);

                //注册成功 创建token
                String token = createToken(tbCfUserInfoVo);
                addTokenInCookie(token, request, response);
                SessionUtils.setSessionUser(request, new SessionUser(token, tbCfUserInfoVo.getAccount()));
                result.setMessage("注册成功！");
                result.setData(tbCfUserInfoVo);
            } else {
                result.setCode(ResultCode.VALIDATE_ERROR);
                result.setMessage("邮箱已被注册！");
            }

            tbCfUserInfoVo.setEnableFlag(StateConstant.VALID);

        }
        return result;


    }

    @Override
    public Result login(String ip, String account, String password) {

        Result result = new Result();
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        if (StringUtils.isNotBlank(token)) {
            TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
            if (tbCfUserInfoVo == null) {
                if(StringUtils.isBlank(account)||StringUtils.isBlank(password)) {
                    tokenManager.remove(token);
                    CookieUtils.removeCookie(response, TokenManager.TOKEN, "/", null);
                    result.setCode(ResultCode.NEED_LOGIN).setMessage("请重新登录");
                } else {
                    password = PasswordProvider.encrypt(password);
                    result = loginOfficial(ip, account,password, token);
                }

            } else {
                if(StringUtils.isBlank(account)) {
                    account=tbCfUserInfoVo.getAccount();
                }
                if(StringUtils.isBlank(password)) {
                    password=tbCfUserInfoVo.getPassword();
                } else {
                    password = PasswordProvider.encrypt(password);
                }
                result = loginOfficial(ip, account,password, token);
            }
        } else {
            Validator.NOT_BLANK.validate("账号", account);
            Validator.NOT_BLANK.validate("密码", password);
            password = PasswordProvider.encrypt(password);
            result = loginOfficial(ip, account, password, null);

        }

        return result;
    }

    /**
     * 登录
     * @param ip
     * @param account
     * @param password
     * @param token
     * @return
     */
    private Result loginOfficial(String ip, String account, String password, String token) {

        Result result = new Result();
        TbCfUserInfoEntity user = findByAccount(account);
        if (user == null) {
            result.setCode(ResultCode.ERROR).setMessage("账号不存在");
        } else if (user.getPassword()!=null&&!user.getPassword().equals(password)) {
            result.setCode(ResultCode.ERROR).setMessage("密码不正确");
        } else if (TrueFalseEnum.FALSE.getValue().equals(user.getEnableFlag())) {
            result.setCode(ResultCode.ERROR).setMessage("已被用户禁用");
            CookieUtils.removeCookie(response, TokenManager.TOKEN, "/", null);
        } else {
            user.setLastLoginIp(ip);
            user.setLoginCount(user.getLoginCount() + 1);
            user.setLastLoginTime(new Date());
            tbCfUserInfoDao.update(user);
            //登录成功
            TbCfUserInfoVo loginUser = new TbCfUserInfoVo();
            BeanUtils.copyProperties(user, loginUser);
            if (StringUtils.isBlank(token)) {
                //用户密码登录成功 创建token
                token = createToken(loginUser);
                addTokenInCookie(token, request, response);

            } else {
                //更新用户
                tokenManager.addToken(token, loginUser);
            }
            SessionUtils.setSessionUser(request, new SessionUser(token, loginUser.getAccount()));
            result.setData(loginUser).setMessage("登录成功");
        }
        return result;
    }

    @Override
    public TbCfUserInfoEntity findByAccount(String account) {
        TbCfUserInfoEntity tbCfUserInfoEntity = tbCfUserInfoDao.findByAccount(account);
        return tbCfUserInfoEntity;
    }

    @Override
    public Result updatePassWord(String newPassword, String oldPassword) {
        //获取用户
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        TbCfUserInfoVo loginUser = tokenManager.validate(token);
        String userId = loginUser.getUserId();
        Result result = new Result();
        int res = tbCfUserInfoDao.updatePassWord(userId, newPassword, oldPassword);
        if (res > 0) {
            logout();
            result.setMessage("修改成功");
        } else {
            result.setCode(ResultCode.ERROR).setMessage("旧密码错误");
        }
        return result;
    }

    @Override
    public Result logout() {
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        if (StringUtils.isNotBlank(token)) {
            tokenManager.remove(token);
        }
        SessionUtils.invalidate(request);
        return new Result("已退出登录");
    }

    @Override
    public int updateUserInfo(TbCfUserInfoVo tbCfUserInfoVo) {
        //获取用户
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        TbCfUserInfoVo loginUser = tokenManager.validate(token);
        String userId = loginUser.getUserId();
        tbCfUserInfoVo.setUserId(userId);
        TbCfUserInfoEntity tbCfUserInfoEntity = new TbCfUserInfoEntity();
        BeanUtils.copyProperties(tbCfUserInfoEntity, tbCfUserInfoVo);
        int res = this.update(tbCfUserInfoEntity);
        return res;
    }

    @Override
    public Result loginByThirdParty(String ip, String account, String nick, String userType) throws UnsupportedEncodingException {
        Result result = new Result();
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        if (StringUtils.isNotBlank(token) && tokenManager.validate(token) != null) {

            TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
            if (tbCfUserInfoVo == null) {
                CookieUtils.removeCookie(response, TokenManager.TOKEN, "/", null);
                result.setCode(ResultCode.ERROR).setMessage("请重新登录");
            } else {
                if(StringUtils.isBlank(account)) {
                    account=tbCfUserInfoVo.getAccount();
                }
                if(StringUtils.isBlank(nick)) {
                    nick=tbCfUserInfoVo.getNick();
                }
                loginByThirdPartyOfficial(token, ip,account ,nick , result);
            }
            //return "redirect:" + authBackUrl(backUrl, token);
        } else {
            Validator.NOT_BLANK.validate("账号", account);
            Validator.NOT_BLANK.validate("用户昵称", nick);
            Validator.NOT_BLANK.validate("用户类型", userType);
            nick = URLDecoder.decode(nick, "UTF-8");
            //根据账号找用户
            TbCfUserInfoEntity oldUser = findByAccount(account);
            //新用户则注册
            if (oldUser == null) {
                UserTypeEnum userTypeEnum = matchUserType(userType);
                TbCfUserInfoVo tbCfUserInfoVo = new TbCfUserInfoVo();
                tbCfUserInfoVo.setAccount(account);
                tbCfUserInfoVo.setUserType(userTypeEnum.getCode());
                tbCfUserInfoVo.setNick(nick);
                tbCfUserInfoVo.setLastLoginIp(ip);
                TbCfUserInfoEntity tbCfUserInfoEntity = new TbCfUserInfoEntity();
                /**
                 * 填充必要信息
                 */
                fillUserNecessayInfo(tbCfUserInfoVo);

                BeanUtils.copyProperties(tbCfUserInfoVo, tbCfUserInfoEntity);
                tbCfUserInfoDao.save(tbCfUserInfoEntity);

                //注册成功 创建token
                buildUserToken(tbCfUserInfoEntity);
                result.setMessage("登录成功").setData(tbCfUserInfoVo);
            } else {
                if(nick.equals(oldUser.getNick())) {
                    oldUser.setLastLoginIp(ip);
                    oldUser.setLoginCount(oldUser.getLoginCount() + 1);
                    oldUser.setLastLoginTime(new Date());
                    tbCfUserInfoDao.update(oldUser);
                    //为用户添加token
                    buildUserToken(oldUser);
                    result.setData(oldUser).setMessage("登录成功");
                } else {
                    result.setCode(ResultCode.NEED_LOGIN).setMessage("请重新登录");
                }

            }
        }
        return result;
    }


    /**
     * 获取用户类型
     * @param userType
     * @return
     */
    private UserTypeEnum matchUserType(String userType) {
        UserTypeEnum userTypeEnum;
        switch (userType) {
            case "1": {
                userTypeEnum = UserTypeEnum.EMAIL;
                break;
            }
            case "2": {
                userTypeEnum = UserTypeEnum.FACEBOOK;
                break;
            }
            case "3": {
                userTypeEnum = UserTypeEnum.PHONE;
                break;
            }
            case "4": {
                userTypeEnum = UserTypeEnum.TWITTER;
                break;
            }
            default: {
                userTypeEnum = UserTypeEnum.UN_KNOW;
                break;
            }
        }
        return userTypeEnum;
    }

    /**
     * 为用户添加token
     *
     * @param oldUser
     */
    private void buildUserToken(TbCfUserInfoEntity oldUser) {
        TbCfUserInfoVo loginUser = new TbCfUserInfoVo();
        BeanUtils.copyProperties(oldUser, loginUser);
        String newToken = createToken(loginUser);
        addTokenInCookie(newToken, request, response);
        SessionUtils.setSessionUser(request, new SessionUser(newToken, loginUser.getAccount()));
    }

    /**
     * 第三方登录
     *
     * @param account
     * @param nick
     * @return
     */
    private void loginByThirdPartyOfficial(String token, String ip, String account, String nick, Result result) {
        TbCfUserInfoEntity user = findByAccount(account);
        if (user != null&&nick.equals(user.getNick())) {
            user.setLastLoginIp(ip);
            user.setLoginCount(user.getLoginCount() + 1);
            user.setLastLoginTime(new Date());
            tbCfUserInfoDao.update(user);
            //更新token用户
            TbCfUserInfoVo loginUser = new TbCfUserInfoVo();
            BeanUtils.copyProperties(user, loginUser);
            tokenManager.addToken(token, loginUser);
            result.setData(user).setMessage("登录成功");
        } else {
            tokenManager.remove(token);
            CookieUtils.removeCookie(response, TokenManager.TOKEN, "/", null);
            result.setCode(ResultCode.NEED_LOGIN).setMessage("请重新登录");
        }
    }


    private void fillUserNecessayInfo(TbCfUserInfoVo tbCfUserInfoVo) {
        tbCfUserInfoVo.setUserId(IdUtil.createIdbyUUID());
        tbCfUserInfoVo.setUserNo(IdUtil.createIdByDate());
        tbCfUserInfoVo.setAvatar(domainProperties.getProperty("user.avatar"));
        tbCfUserInfoVo.setPhoneFlag(StateConstant.INVALID);
        tbCfUserInfoVo.setLoginCount(0);
        tbCfUserInfoVo.setCreateTime(new Date());
        tbCfUserInfoVo.setSex(SexEnum.UNKNOW.getCode());
        tbCfUserInfoVo.setInvitedCount(0);
        tbCfUserInfoVo.setEnableFlag(StateConstant.VALID);
    }

    //创建token
    private String createToken(TbCfUserInfoVo loginUser) {
        // 生成token
        String token = IdUtil.createIdbyUUID();
        // 缓存中添加token对应User
        tokenManager.addToken(token, loginUser);
        return token;
    }

    //添加cookie
    private void addTokenInCookie(String token, HttpServletRequest request, HttpServletResponse response) {
        // Cookie添加token
        Cookie cookie = new Cookie(TokenManager.TOKEN, token);
        cookie.setPath("/");
        if ("https".equals(request.getScheme())) {
            cookie.setSecure(true);
        }
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

}
