package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfStoreDao;
import com.diaoyun.zion.chinafrica.entity.TbCfStoreEntity;
import com.diaoyun.zion.chinafrica.service.TbCfStoreService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.Map;

/**
 * 店铺管理Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfStoreService")
public class TbCfStoreServiceImpl implements TbCfStoreService {
    @Autowired
    private TbCfStoreDao tbCfStoreDao;

    @Override
    public TbCfStoreEntity queryObject(String storeId) {
        return tbCfStoreDao.queryObject(storeId);
    }

    @Override
    public List<TbCfStoreEntity> queryList(Map<String, Object> map) {
        return tbCfStoreDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfStoreDao.queryTotal(map);
    }

    @Override
    public int save(TbCfStoreEntity tbCfStore) {
        tbCfStore.setStoreId(IdUtil.createIdbyUUID());
        return tbCfStoreDao.save(tbCfStore);
    }

    @Override
    public int update(TbCfStoreEntity tbCfStore) {
        return tbCfStoreDao.update(tbCfStore);
    }

    @Override
    public int delete(String storeId) {
        return tbCfStoreDao.delete(storeId);
    }

    @Override
    public int deleteBatch(String[] storeIds) {
        return tbCfStoreDao.deleteBatch(storeIds);
    }
}
