package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfPlatformOrderDao;
import com.diaoyun.zion.chinafrica.entity.TbCfPlatformOrderEntity;
import com.diaoyun.zion.chinafrica.service.TbCfPlatformOrderService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 第三方平台对应订单信息Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Service("tbCfPlatformOrderService")
public class TbCfPlatformOrderServiceImpl implements TbCfPlatformOrderService {
    @Autowired
    private TbCfPlatformOrderDao tbCfPlatformOrderDao;

    @Override
    public TbCfPlatformOrderEntity queryObject(String relativeId) {
        return tbCfPlatformOrderDao.queryObject(relativeId);
    }

    @Override
    public List<TbCfPlatformOrderEntity> queryList(Map<String, Object> map) {
        return tbCfPlatformOrderDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfPlatformOrderDao.queryTotal(map);
    }

    @Override
    public int save(TbCfPlatformOrderEntity tbCfPlatformOrder) {
        tbCfPlatformOrder.setPOrderId(IdUtil.createIdbyUUID());
        return tbCfPlatformOrderDao.save(tbCfPlatformOrder);
    }

    @Override
    public int update(TbCfPlatformOrderEntity tbCfPlatformOrder) {
        return tbCfPlatformOrderDao.update(tbCfPlatformOrder);
    }

    @Override
    public int delete(String relativeId) {
        return tbCfPlatformOrderDao.delete(relativeId);
    }

    @Override
    public int deleteBatch(String[] relativeIds) {
        return tbCfPlatformOrderDao.deleteBatch(relativeIds);
    }
}
