package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfCartRecordRDao;
import com.diaoyun.zion.chinafrica.dao.TbCfItemDetailDao;
import com.diaoyun.zion.chinafrica.entity.TbCfCartRecordREntity;
import com.diaoyun.zion.chinafrica.entity.TbCfItemDetailEntity;
import com.diaoyun.zion.chinafrica.service.TbCfItemDetailService;
import com.diaoyun.zion.chinafrica.vo.TbCfCartItemDetailVo;
import com.diaoyun.zion.chinafrica.vo.TbCfItemDetailVo;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.ResultCode;
import com.diaoyun.zion.master.base.StateConstant;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.util.CookieUtils;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 商品详情Service实现类
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@Service("tbCfItemDetailService")
public class TbCfItemDetailServiceImpl implements TbCfItemDetailService {
    @Autowired
    private TbCfItemDetailDao tbCfItemDetailDao;

    @Autowired
    private TbCfCartRecordRDao tbCfCartRecordRDao;

    @Resource(name="redisTokenManager")
    private TokenManager tokenManager;

    @Autowired
    private HttpServletRequest request; //自动注入request


    @Override
    public TbCfItemDetailEntity queryObject(String itemId) {
        return tbCfItemDetailDao.queryObject(itemId);
    }

    @Override
    public List<TbCfItemDetailEntity> queryList(Map<String, Object> map) {
        return tbCfItemDetailDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfItemDetailDao.queryTotal(map);
    }

    @Override
    public int save(TbCfItemDetailEntity tbCfItemDetail) {
        tbCfItemDetail.setItemId(IdUtil.createIdbyUUID());
        return tbCfItemDetailDao.save(tbCfItemDetail);
    }

    @Override
    public int update(TbCfItemDetailEntity tbCfItemDetail) {
        return tbCfItemDetailDao.update(tbCfItemDetail);
    }

    @Override
    public int delete(String itemId) {
        return tbCfItemDetailDao.delete(itemId);
    }

    @Override
    public int deleteBatch(String[] itemIds) {
        return tbCfItemDetailDao.deleteBatch(itemIds);
    }

    @Override
    public Result addToCart(TbCfItemDetailVo tbCfItemDetailVo) {
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        //填充新商品必要信息
        fillItemInfo(tbCfItemDetailVo);
        //加入商品详情
        TbCfItemDetailEntity tbCfItemDetail= new TbCfItemDetailEntity();
        BeanUtils.copyProperties(tbCfItemDetailVo,tbCfItemDetail);
        //将商品加入购物车表
        tbCfItemDetailDao.save(tbCfItemDetail);
        TbCfCartRecordREntity tbCfCartRecordREntity = new TbCfCartRecordREntity();
        tbCfCartRecordREntity.setCartRecordId(IdUtil.createIdbyUUID());
        tbCfCartRecordREntity.setCheckFlag(StateConstant.VALID);
        tbCfCartRecordREntity.setEnableFlag(StateConstant.VALID);
        tbCfCartRecordREntity.setItemId(tbCfItemDetailVo.getItemId());
        tbCfCartRecordREntity.setUserId(tbCfUserInfoVo.getUserId());
        tbCfCartRecordREntity.setCreateTime(new Date());
        tbCfCartRecordRDao.save(tbCfCartRecordREntity);
        return new Result("成功加入购物车");
    }

    @Override
    public Result changeItemNum(String itemId, int itemNum) {
        TbCfItemDetailEntity tbCfItemDetailEntity = new TbCfItemDetailEntity();
        tbCfItemDetailEntity.setItemId(itemId);
        tbCfItemDetailEntity.setItemNum(itemNum);
        int res=tbCfItemDetailDao.update(tbCfItemDetailEntity);
        if(res>0) {
            return new Result("修改成功");
        } else {
            return new Result("修改失败").setCode(ResultCode.ERROR);
        }

    }

    @Override
    public List<TbCfCartItemDetailVo> getCartItemList() {
        //获取用户
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        String userId=tbCfUserInfoVo.getUserId();
        List<TbCfCartItemDetailVo> TbCfCartItemDetailList=tbCfItemDetailDao.getCartItemList(userId,null);
        return TbCfCartItemDetailList;
    }

    @Override
    public Result changeItemState(String cartRecordId, Integer checkFlag) {
        Result result=new Result("修改成功");
        int res=tbCfItemDetailDao.changeItemState(cartRecordId,checkFlag);
        if(res<1) {
            result.setMessage("修改失败");
        }
        return result;
    }

    /**
     * 填充新商品必要信息
     * @param tbCfItemDetailVo
     */
    private void fillItemInfo(TbCfItemDetailVo tbCfItemDetailVo) {
        tbCfItemDetailVo.setItemId(IdUtil.createIdbyUUID());
        tbCfItemDetailVo.setCreateTime(new Date());
    }
}
