package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfFeedbackDao;
import com.diaoyun.zion.chinafrica.entity.TbCfFeedbackEntity;
import com.diaoyun.zion.chinafrica.service.TbCfFeedbackService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 反馈情况Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfFeedbackService")
public class TbCfFeedbackServiceImpl implements TbCfFeedbackService {
    @Autowired
    private TbCfFeedbackDao tbCfFeedbackDao;

    @Override
    public TbCfFeedbackEntity queryObject(String feedbackId) {
        return tbCfFeedbackDao.queryObject(feedbackId);
    }

    @Override
    public List<TbCfFeedbackEntity> queryList(Map<String, Object> map) {
        return tbCfFeedbackDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfFeedbackDao.queryTotal(map);
    }

    @Override
    public int save(TbCfFeedbackEntity tbCfFeedback) {
        tbCfFeedback.setFeedbackId(IdUtil.createIdbyUUID());
        return tbCfFeedbackDao.save(tbCfFeedback);
    }

    @Override
    public int update(TbCfFeedbackEntity tbCfFeedback) {
        return tbCfFeedbackDao.update(tbCfFeedback);
    }

    @Override
    public int delete(String feedbackId) {
        return tbCfFeedbackDao.delete(feedbackId);
    }

    @Override
    public int deleteBatch(String[] feedbackIds) {
        return tbCfFeedbackDao.deleteBatch(feedbackIds);
    }
}
