package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfCartRecordRDao;
import com.diaoyun.zion.chinafrica.entity.TbCfCartRecordREntity;
import com.diaoyun.zion.chinafrica.service.TbCfCartRecordRService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.ResultCode;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 购物车记录表Service实现类
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@Service("tbCfCartRecordRService")
public class TbCfCartRecordRServiceImpl implements TbCfCartRecordRService {
    @Autowired
    private TbCfCartRecordRDao tbCfCartRecordRDao;

    @Override
    public TbCfCartRecordREntity queryObject(String cartRecordId) {
        return tbCfCartRecordRDao.queryObject(cartRecordId);
    }

    @Override
    public List<TbCfCartRecordREntity> queryList(Map<String, Object> map) {
        return tbCfCartRecordRDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfCartRecordRDao.queryTotal(map);
    }

    @Override
    public int save(TbCfCartRecordREntity tbCfCartRecordR) {
        tbCfCartRecordR.setCartRecordId(IdUtil.createIdbyUUID());
        return tbCfCartRecordRDao.save(tbCfCartRecordR);
    }

    @Override
    public int update(TbCfCartRecordREntity tbCfCartRecordR) {
        return tbCfCartRecordRDao.update(tbCfCartRecordR);
    }

    @Override
    public int delete(String cartRecordId) {
        return tbCfCartRecordRDao.delete(cartRecordId);
    }

    @Override
    public int deleteBatch(String[] cartRecordIds) {
        return tbCfCartRecordRDao.deleteBatch(cartRecordIds);
    }

    @Override
    public Result deleteItems(String[] cartRecordIds) {
        int res=tbCfCartRecordRDao.deleteItems(cartRecordIds);
        if(res>0) {
            return new Result("修改成功");
        } else {
            return new Result("修改失败").setCode(ResultCode.ERROR);
        }
    }
}
