package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.bis.impl.NetWorkSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.factory.ItemSpiderFactory;
import com.diaoyun.zion.chinafrica.service.SpiderService;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.stereotype.Service;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.*;
import java.util.concurrent.ExecutionException;

@Service("spiderService")
public class SpiderServiceImpl implements SpiderService {

    //淘宝商品详情
    private static final String taobaoUrl="https://item.taobao.com/item.htm?";

    @Override
    public Map<String, Object> getItemDetail(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException {
        //主要是判断淘宝的url是手机端还是PC端，如果是手机端，那么还需要提取相关参数，组成新的url；还有去除链接中一些会引起请求错误的参数
        targetUrl=processUrl(targetUrl);
        //判断链接属于哪个平台
        PlatformEnum platformEnum=judgeUrlType(targetUrl);
        IItemSpider iItemSpider=ItemSpiderFactory.getSpider(platformEnum);
        Map<String,Object> itemMap=iItemSpider.captureItem(targetUrl);
        return itemMap;
    }

    @Override
    public BigDecimal getExchangeRate(String currency) throws IOException, URISyntaxException {

        //默认人民币换美元
        if(StringUtils.isBlank(currency)) {
            currency="FOREXUSDCNY";
        }
        BigDecimal exchangeRate=NetWorkSpider.getRateFromHexun(currency);
        return exchangeRate;
    }


    /**
     * 主要是提取相关参数，组成新的url
     *
     * @param targetUrl
     * @return
     */
    private String processUrl(String targetUrl) throws URISyntaxException {
        String newUrl=taobaoUrl;
        //if(targetUrl.contains("h5.m.taobao.com")) {
        Map<String,String> paramMap=getParamMap(targetUrl);
        //目前淘宝需要四个参数 spm id scm pvid
        //引起错误的 参数 ali_refid
        StringBuffer paramBuffer=new StringBuffer();
        for(Map.Entry<String,String> entry:paramMap.entrySet()) {
            if("ali_refid".equals(entry.getKey())) {

            } else {
                paramBuffer.append(entry.getKey()+"="+entry.getValue()+"&");
            }
        }

        return newUrl+paramBuffer.toString();

    }

    /**
     * 获取连接中的参数
     * @param targetUrl
     * @return
     */
    private Map<String, String> getParamMap(String targetUrl) throws URISyntaxException {
        List<NameValuePair> params = URLEncodedUtils.parse(new URI(targetUrl), Charset.forName("UTF-8"));
        Map<String,String> paramMap=new HashMap<>();
        for (NameValuePair param : params) {
            paramMap.put(param.getName(),param.getValue());
        }
        return paramMap;
    }

    private PlatformEnum judgeUrlType(String targetUrl) {
        PlatformEnum platformEnum = PlatformEnum.UN;
        if(targetUrl.contains("taobao.com")) {
            platformEnum=PlatformEnum.TB;
        }
        return platformEnum;
    }
}
