package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfStoreEntity;

import java.util.List;
import java.util.Map;

/**
 * 店铺管理Service接口
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
public interface TbCfStoreService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfStoreEntity queryObject(String storeId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfStoreEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfStore 实体
     * @return 保存条数
     */
    int save(TbCfStoreEntity tbCfStore);

    /**
     * 根据主键更新实体
     *
     * @param tbCfStore 实体
     * @return 更新条数
     */
    int update(TbCfStoreEntity tbCfStore);

    /**
     * 根据主键删除
     *
     * @param storeId
     * @return 删除条数
     */
    int delete(String storeId);

    /**
     * 根据主键批量删除
     *
     * @param storeIds
     * @return 删除条数
     */
    int deleteBatch(String[] storeIds);
}
