package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfPlatformEntity;

import java.util.List;
import java.util.Map;

/**
 * 平台管理Service接口
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
public interface TbCfPlatformService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfPlatformEntity queryObject(String platformId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfPlatformEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfPlatform 实体
     * @return 保存条数
     */
    int save(TbCfPlatformEntity tbCfPlatform);

    /**
     * 根据主键更新实体
     *
     * @param tbCfPlatform 实体
     * @return 更新条数
     */
    int update(TbCfPlatformEntity tbCfPlatform);

    /**
     * 根据主键删除
     *
     * @param platformId
     * @return 删除条数
     */
    int delete(String platformId);

    /**
     * 根据主键批量删除
     *
     * @param platformIds
     * @return 删除条数
     */
    int deleteBatch(String[] platformIds);
}
