package com.diaoyun.zion.chinafrica.service;


import com.diaoyun.zion.chinafrica.entity.TbCfItemDetailEntity;
import com.diaoyun.zion.chinafrica.vo.TbCfCartItemDetailVo;
import com.diaoyun.zion.chinafrica.vo.TbCfItemDetailVo;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 商品详情Service接口
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
public interface TbCfItemDetailService {

    /**
     * 根据主键查询实体
     *
     * @param itemId 主键
     * @return 实体
     */
    TbCfItemDetailEntity queryObject(String itemId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfItemDetailEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfItemDetail 实体
     * @return 保存条数
     */
    int save(TbCfItemDetailEntity tbCfItemDetail);

    /**
     * 根据主键更新实体
     *
     * @param tbCfItemDetail 实体
     * @return 更新条数
     */
    int update(TbCfItemDetailEntity tbCfItemDetail);

    /**
     * 根据主键删除
     *
     * @param itemId
     * @return 删除条数
     */
    int delete(String itemId);

    /**
     * 根据主键批量删除
     *
     * @param itemIds
     * @return 删除条数
     */
    int deleteBatch(String[] itemIds);

    /**
     * 商品加入到购物车
     * @param tbCfItemDetailVo
     * @return
     */
    Result addToCart(TbCfItemDetailVo tbCfItemDetailVo);

    /**
     * 更改购物车商品数量
     * @param itemId
     * @param itemNum
     * @return
     */
    Result changeItemNum(String itemId, int itemNum);


    /**
     * 获取用户购物车内商品
     * @return
     */
    List<TbCfCartItemDetailVo> getCartItemList();

    /**
     * 改变购物车的商品勾选状态
     * @param cartRecordId
     * @param enableFlag
     * @return
     */
    Result changeItemState(String cartRecordId, Integer enableFlag);
}
