package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfExpressTemplateEntity;

import java.util.List;
import java.util.Map;

/**
 * 运费模板Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfExpressTemplateService {

    /**
     * 根据主键查询实体
     *
     * @param templateId 主键
     * @return 实体
     */
    TbCfExpressTemplateEntity queryObject(String templateId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfExpressTemplateEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfExpressTemplate 实体
     * @return 保存条数
     */
    int save(TbCfExpressTemplateEntity tbCfExpressTemplate);

    /**
     * 根据主键更新实体
     *
     * @param tbCfExpressTemplate 实体
     * @return 更新条数
     */
    int update(TbCfExpressTemplateEntity tbCfExpressTemplate);

    /**
     * 根据主键删除
     *
     * @param templateId
     * @return 删除条数
     */
    int delete(String templateId);

    /**
     * 根据主键批量删除
     *
     * @param templateIds
     * @return 删除条数
     */
    int deleteBatch(String[] templateIds);
}
