package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfCartRecordREntity;
import com.diaoyun.zion.chinafrica.vo.TbCfCartItemDetailVo;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 购物车记录表Service接口
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
public interface TbCfCartRecordRService {

    /**
     * 根据主键查询实体
     *
     * @param cartRecordId 主键
     * @return 实体
     */
    TbCfCartRecordREntity queryObject(String cartRecordId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfCartRecordREntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfCartRecordR 实体
     * @return 保存条数
     */
    int save(TbCfCartRecordREntity tbCfCartRecordR);

    /**
     * 根据主键更新实体
     *
     * @param tbCfCartRecordR 实体
     * @return 更新条数
     */
    int update(TbCfCartRecordREntity tbCfCartRecordR);

    /**
     * 根据主键删除
     *
     * @param cartRecordId
     * @return 删除条数
     */
    int delete(String cartRecordId);

    /**
     * 根据主键批量删除
     *
     * @param cartRecordIds
     * @return 删除条数
     */
    int deleteBatch(String[] cartRecordIds);

    /**
     * 删除购物车内的商品
     * @param cartRecordIds
     * @return
     */
    Result deleteItems(String[] cartRecordIds);


}
