package com.diaoyun.zion.chinafrica.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public interface SpiderService {
    /**
     * 爬取数据获取商品详情
     * @param targetUrl
     * @return
     */
    Map<String, Object> getItemDetail(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException;


    /**
     * 获取汇率
     * @param currency FOREXUSDCNY 人民币换美元
     * @return
     */
    BigDecimal getExchangeRate(String currency) throws IOException, URISyntaxException;
}
