package com.diaoyun.zion.chinafrica.rpc.impl;

import com.diaoyun.zion.chinafrica.client.SessionUser;
import com.diaoyun.zion.chinafrica.rpc.AuthenticationRpcService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.common.TokenManager;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;

@Service("authenticationRpcService")
public class AuthenticationRpcServiceImpl implements AuthenticationRpcService {
	@Resource(name="redisTokenManager")
	private TokenManager tokenManager;

	@Override
	public boolean validate(String token) {
		return tokenManager.validate(token) != null;
	}
	
	@Override
	public SessionUser findAuthInfo(String token) {
		TbCfUserInfoVo user = tokenManager.validate(token);
		if (user != null) {
			return new SessionUser(token,user.getAccount());
		}
		return null;
	}

}
